<?php


class util
{

	function readfile( $file )
	{
		$fp = fopen( $file, "r" );
		flock( $fp, 1 );
		$content = fread( $fp, filesize( $file ) );
		fclose( $fp );
		return $content;
	}

	function writefile( $file, $content, $mode = "w+" )
	{
		if ( !file_exists( $file ) )
		{
			util::makefile( $file );
		}
		$fp = fopen( $file, $mode );
		flock( $fp, 2 );
		$result = fwrite( $fp, $content );
		fclose( $fp );
		return $result;
	}

	function makefile( $fileName, $content = "" )
	{
		$path = substr( $fileName, 0, strrpos( $fileName, "/" ) );
		util::makedir( $path );
		$fp = fopen( $fileName, "w+" );
		fwrite( $fp, $content );
		fclose( $fp );
		return true;
	}

	function makedir( $path )
	{
		if ( FALSE !== strpos( $path, "./" ) )
		{
			$path = util::getrealpath( $path );
		}
		$path = str_replace( "\\", "/", $path );
		if ( file_exists( $path ) )
		{
			return true;
		}
		$dirs = explode( "/", $path );
		$dir_tmp = "";
		$i = 0;
		for ( ;	$i < count( $dirs );	++$i	)
		{
			$dir_tmp .= $dirs[$i]."/";
			if ( !file_exists( $dir_tmp ) )
			{
				mkdir( $dir_tmp );
			}
		}
		return true;
	}

	function getrealpath( $path )
	{
		$path = str_replace( "\\", "/", $path );
		$parts = array_filter( explode( "/", $path ), "strlen" );
		$relativePath = "";
		foreach ( $parts as $part )
		{
			if ( "." == $part || !( ".." == $part ) )
			{
				$relativePath .= $part."/";
				array_shift( $parts );
			}
		}
		return realpath( $relativePath ).implode( DIRECTORY_SEPARATOR, $parts );
	}

	function gpc( $gpcType = "" )
	{
		$gpcFlag = ini_get( "magic_quotes_gpc" );
		if ( $gpcFlag )
		{
			return;
		}
		if ( is_array( $_GET ) )
		{
			foreach ( $GLOBALS['_GET'] as $key => $value )
			{
				$GLOBALS['_GET'][$key] = addslashes( $value );
			}
		}
		if ( is_array( $_POST ) )
		{
			foreach ( $GLOBALS['_POST'] as $key => $value )
			{
				if ( !is_array( $_POST[$key] ) )
				{
					$GLOBALS['_POST'][$key] = addslashes( $value );
				}
				else
				{
					foreach ( $GLOBALS['_POST'][$key] as $key => $value )
					{
						$GLOBALS['_POST'][$key][$key] = addslashes( $value );
					}
				}
			}
		}
	}

	function printarray( $arr )
	{
		echo "<xmp>";
		print_r( $arr );
		echo "</xmp>";
	}

	function auth( )
	{

	}

	function quit( $msg )
	{

	}

}

?>
