<?php
class WeixinModel extends CommonModel {
	// 自动验证设置
	protected $_validate = array(
            array('catid','require','所属分类必选'),
            array('pubaccount','require','公众帐号必填'),
            array('logo,weblogo','checklogo','本地头像与网络头像必填一个！',1,'callback'),
            array('qrcode,webqrcode','checkqrcode','本地二维码与网络二维码必填一个！',1,'callback'),
            array('content','require','帐号介绍必填'),
            array('pubaccount','','公众帐号已经存在',0,'unique',self::MODEL_INSERT),
            array('title','','标题已经存在',0,'unique',self::MODEL_INSERT),
            
        );
	// 自动填充设置
	protected $_auto = array(
            array('typeid','1',self::MODEL_INSERT),
            array('hits','0',self::MODEL_INSERT),
            array('zhiding','0',self::MODEL_INSERT),
            array('curtuijian','0',self::MODEL_INSERT),
            array('tuijian','0',self::MODEL_INSERT),
            array('xingji','5',self::MODEL_INSERT),
            array('ip','get_client_ip',self::MODEL_BOTH,'function'),
            array('status','2',self::MODEL_UPDATE),
            array('create_time','time',self::MODEL_INSERT,'function'),
            array('update_time','time',self::MODEL_BOTH,'function'),
        );
        
        //定义判断头像函数
        public function checklogo($data){
            $logo = $data['logo'];
            $weblogo= $data['weblogo'];
            if(empty($logo)&&empty($weblogo)){
                return false;
            }else{
                return true;
            }
        }
        //定义判断二维码函数
        public function checkqrcode($data){
            $qrcode = $data['qrcode'];
            $webqrcode= $data['webqrcode'];
            if(empty($qrcode)&&empty($webqrcode)){
                return false;
            }else{
                return true;
            }
        }
        public function getMyCategory(){
            $map['status']  = array('egt',0);
            $map['modelname']  = array('eq','Weixin');
            $cat=D('Category');
            $list=$cat->where($map)->field("*,concat(path,'-',id) as bpath")->order('bpath')->select();

            foreach($list as $key=>$value){
                $list[$key]['count']=count(explode('-',$value['bpath']));
            }
            return $list;
        }
        //获取栏目菜单
        public function getMyCategory1() {
            //读取数据库模块列表生成菜单项   
            $node = D ( "Category" );  
            $map ['status'] =array("egt",0); 
            $list = $node->where($map)->order( 'level,listorder' )->select();  
            return $list;
        }
        //获取栏目菜单
        public function getModelCategory($modelname) {
            //读取数据库模块列表生成菜单项   
            $node = D ( "Category" );  
            $map ['status'] =array("egt",0); 
            $map['modelname']=array('eq',$modelname);
            $map['catdir']=array(array('eq',''),array('exp','is null'),'OR');
            $list = $node->where($map)->order( 'level,listorder')->select(); 
            return $list;
        }

}
?>