<?php
$content=<<<eof
CREATE TABLE `sky_mod_pinche_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_per_money` tinyint(4) NOT NULL DEFAULT '0' COMMENT '站点抽成',
  `invite_per_money` tinyint(4) NOT NULL DEFAULT '0' COMMENT '邀请抽成',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='拼车设置';
CREATE TABLE `sky_mod_pinche_driver` (
  `driverid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `truename` varchar(12) NOT NULL DEFAULT '' COMMENT '昵称',
  `userhead` varchar(225) NOT NULL DEFAULT '' COMMENT '头像',
  `description` varchar(225) NOT NULL DEFAULT '' COMMENT '介绍',
  `carno` varchar(12) NOT NULL DEFAULT '' COMMENT '车牌号',
  `carpic` varchar(225) NOT NULL DEFAULT '' COMMENT '车辆图片',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `isfree` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '空闲',
  `bzmoney` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '保证金',
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `telephone` varchar(18) NOT NULL DEFAULT '',
  PRIMARY KEY (`driverid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='拼车司机';
CREATE TABLE `sky_mod_pinche_driver_account` (
  `driverid` int(10) unsigned NOT NULL,
  `total_money` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '总收入',
  `balance_money` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`driverid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='司机账户';
CREATE TABLE `sky_mod_pinche_driver_account_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '时间',
  `driverid` int(11) NOT NULL DEFAULT '0' COMMENT '司机',
  `money` decimal(11,2) NOT NULL DEFAULT '0.00',
  `typeid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='拼车日志';
CREATE TABLE `sky_mod_pinche_driver_apply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `truename` varchar(12) NOT NULL DEFAULT '' COMMENT '昵称',
  `userhead` varchar(225) NOT NULL DEFAULT '' COMMENT '头像',
  `description` varchar(225) NOT NULL DEFAULT '' COMMENT '介绍',
  `carno` varchar(12) NOT NULL DEFAULT '' COMMENT '车牌号',
  `carpic` varchar(225) NOT NULL DEFAULT '' COMMENT '车辆图片',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `userno` varchar(22) NOT NULL DEFAULT '' COMMENT '身份证号码',
  `usercarda` varchar(225) NOT NULL DEFAULT '' COMMENT '身份证正面',
  `usercardb` varchar(225) NOT NULL DEFAULT '' COMMENT '身份证反面',
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `telephone` varchar(18) NOT NULL DEFAULT '',
  `driverpic` varchar(225) NOT NULL DEFAULT '',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `address` varchar(225) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='拼车司机申请';
CREATE TABLE `sky_mod_pinche_driver_auth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `driverid` int(10) unsigned NOT NULL DEFAULT '0',
  `userno` varchar(22) NOT NULL DEFAULT '' COMMENT '身份证号码',
  `usercarda` varchar(225) NOT NULL DEFAULT '' COMMENT '身份证正面',
  `usercardb` varchar(225) NOT NULL DEFAULT '' COMMENT '身份证反面',
  `carno` varchar(12) NOT NULL DEFAULT '' COMMENT '车牌号码',
  `carpic` varchar(225) NOT NULL DEFAULT '' COMMENT '车的照片',
  `createtime` varchar(225) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `driverpic` varchar(225) NOT NULL DEFAULT '' COMMENT '驾驶证',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='拼车司机';
CREATE TABLE `sky_mod_pinche_driver_line` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `driverid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '司机',
  `lineid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '线路',
  `freetime` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `driverid` (`driverid`),
  KEY `lineid` (`lineid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='司机线路';
CREATE TABLE `sky_mod_pinche_group` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `driverid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '司机',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `usernum` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '乘客人数',
  `freenum` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `money` int(10) unsigned NOT NULL DEFAULT '0',
  `ptime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '成团时间',
  `lineid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`),
  KEY `driverid` (`driverid`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COMMENT='拼车团';
CREATE TABLE `sky_mod_pinche_group_msg` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `driverid` int(10) unsigned NOT NULL DEFAULT '0',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `content` varchar(225) NOT NULL DEFAULT '',
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COMMENT='聊天室';
CREATE TABLE `sky_mod_pinche_line` (
  `lineid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL DEFAULT '' COMMENT '路线名称',
  `basemoney` int(10) unsigned NOT NULL DEFAULT '0',
  `start_addr` varchar(12) NOT NULL DEFAULT '' COMMENT '开始地址',
  `start_lat` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '开始纬度',
  `start_lng` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '开始精度',
  `sendmoney` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '接车费用 3/千米',
  `end_addr` varchar(12) NOT NULL DEFAULT '' COMMENT '结束地址',
  `end_lat` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '结束纬度',
  `end_lng` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '结束精度',
  `imgurl` varchar(225) NOT NULL DEFAULT '' COMMENT '线路图图片',
  `description` varchar(225) NOT NULL DEFAULT '' COMMENT '描述',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lineid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='拼车线路';
CREATE TABLE `sky_mod_pinche_line_addr` (
  `addrid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lineid` int(10) unsigned NOT NULL DEFAULT '0',
  `addr` varchar(12) NOT NULL DEFAULT '' COMMENT '地址',
  `lat` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '纬度',
  `lng` decimal(9,6) NOT NULL DEFAULT '0.000000' COMMENT '精度',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `stype` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '类型 1七点 2终点',
  PRIMARY KEY (`addrid`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COMMENT='线路地址';
CREATE TABLE `sky_mod_pinche_order` (
  `orderid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下单人',
  `invite_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '金额',
  `ispay` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '支付',
  `usernum` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '人数',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `driverid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '司机',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '成团',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `start_addrid` int(10) unsigned NOT NULL DEFAULT '0',
  `start_lat` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `start_lng` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `end_addrid` int(10) unsigned NOT NULL DEFAULT '0',
  `lineid` int(10) unsigned NOT NULL DEFAULT '0',
  `end_lat` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `end_lng` decimal(9,6) NOT NULL DEFAULT '0.000000',
  PRIMARY KEY (`orderid`),
  KEY `userid` (`userid`),
  KEY `driverid` (`driverid`),
  KEY `gid` (`gid`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COMMENT='订单';

eof;
?>