<!DOCTYPE html>
<html>
	<?php echo $this->fetch('head.html'); ?>
	<style>
		.abox{
			border-radius: 10px;
			background-color: #fff;
			padding: 10px;
			margin: 10px 10px;
		}
		.abox-item{
			display: flex;
			flex-direction: row;
			align-items: center;
			border-bottom: 1px solid #eee;
			margin-bottom: 5px;
			padding-bottom: 5px;
			
		}
		.abox-usernum{
			height: 25px;
			line-height: 25px;
			border: 1px solid #eee;
			border-radius: 5px;
			margin-right: 5px;
			padding: 0px 5px;
			width: 60px;
		}
		.cbox{
			padding: 20px;
		}
		.btn-round-small{
			background-color: #fdfdfd;
			align-items: center;
			justify-content: center;
			width:50px;
			height: 50px;
			line-height: 50px;
			border-radius: 50px;
			margin-bottom: 10px;
			color: darkblue;
			
		}
		.flex-jc-space-evenly{
			justify-content: space-evenly;
		}
		.modalMap{
			position: fixed;
			bottom:10px;
			left:10px;
			right:10px;
			z-index: 999;
			background-color: #fff;
		}
		.map{
			width:100%;
			height: 240px;
		}
	</style>
	<body>
		<div class="header">
			<div class="header-title">福鼎拼车</div>
		</div>
		<div class="header-row"></div>
		<div class="main-body none" :class="'flex-col'" id="App">
			<div class="banner">
				<img class="wmax" src="<?php echo $this->_var['skins']; ?>img/banner.jpg" />
			</div>
			<div class="abox">
				<div class="abox-item" @click="lineClass='flex-col'">
					<div class="iconfont icon-repeal mgr-5"></div>
					<div v-if="Object.keys(activeLine).length>0">{{activeLine.title}}</div>
					<div v-else>请选择拼车线路</div>
					<div class="flex-1"></div>
					<div class="iconfont icon-right"></div>
				</div>
				
				<div class="abox-item">
					<div class="iconfont icon-my_light mgr-5"></div>
					<input class="abox-usernum" min="1" max="4" type="number" v-model="usernum" />
					<div>人</div>
					
				</div>
				<template  v-if="Object.keys(activeLine).length>0" >
				<div class="abox-item" @click="startAddrShow">
					<div class="iconfont icon-goup mgr-5"></div>
					<div v-if="start_addr!=''">{{start_addr}}</div>
					<div v-else-if="Object.keys(activeLine).length>0">{{activeLine.start_addr}}</div>
					<div v-else>请选择上车位置</div>
					<div class="flex-1"></div>
					<div class="iconfont icon-right"></div>
				</div>
				<div class="abox-item"  @click="endAddrClass='flex-col'">
					<div class="iconfont icon-godown mgr-5"></div>
					<div v-if="end_addr!=''">{{end_addr}}</div>
					<div v-else-if="Object.keys(activeLine).length>0">{{activeLine.end_addr}}</div>
					<div v-else>请选择下车位置</div>
					<div class="flex-1"></div>
					<div class="iconfont icon-right"></div>
				</div>
				
					
					<div class="abox-item flex-wrap">
						<div class="cl2">当前线路基本费用:</div>
						<div class="cl-money mgr-5">￥{{activeLine.basemoney}}</div>
				
						 
						<div class="cl2">，非站点接送另付费用</div>
						<div class="cl-money">￥{{activeLine.sendmoney}}/千米</div>
						
					</div>
					<div class="abox-item">
						<div class="mgr-5">车费</div>
						<div class="cl-money">￥{{totalmoney}}</div>
					</div>
					<div>
						<div @click="orderSubmit" class="btn-row-submit">确认拼车</div>
					</div>
				</template>
			</div>
			
			
			<div class="abox text-center">
				福鼎拼车帮助提升乡镇交通便利
			</div>
			<div class="cbox">
				<div class="flex flex-jc-space-evenly">
					<div gourl="/module.php?m=pinche_driver_apply" class="pointer">
						<div class="iconfont btn-round-small icon-taxi"></div>
						<div>车主招募</div>
					</div>
					
					<div  gourl="/module.php?m=pinche_coupon" class="pointer">
						<div class="iconfont btn-round-small icon-ticket"></div>
						<div>邀请有奖</div>
					</div>
				</div>
			</div>
			<div class="modal-group" :class="lineClass">
				<div @click="lineClass=''" class="modal-mask"></div>
				<div class="modal">
					<div class="pd-10">
						<div class="row-item-text" @click="choiceLine(item)" v-for="(item,index) in lineList" :key="index">							
							{{item.title}}
						</div>
					</div>
				</div>
			</div>
			<div class="modal-group" :class="startAddrClass">
				<div @click="startAddrClass=''" class="modal-mask"></div>
				<div class="modalMap">
					<div class="pd-10">
						<div class="flex mgb-10">
							
							<div  @click="choiceStartAddr('')"  class="cl-primary pointer">{{activeLine.start_addr}}</div>
							<div class="flex-1"></div>
							<div @click="choiceStartAddr('当前位置')" class="btn-mini">当前定位</div>
						</div>
						
						<div id="localMap" class="map"></div>
					</div>
				</div>
			</div>
			<div class="modal-group" :class="endAddrClass">
				<div @click="endAddrClass=''" class="modal-mask"></div>
				<div class="modalMap">
					<div class="pd-10">
						<div class="cl-primary pointer"  @click="choiceEndAddr('')">{{activeLine.end_addr}}</div>
						<div class="row-item-text" @click="choiceEndAddr(item)" v-for="(item,index) in endList" :key="index">
							{{item.addr}}
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->assign('ftnav','home'); ?>
		<?php echo $this->fetch('ftnav.html'); ?>
		<?php echo $this->fetch('footer.html'); ?>
		<script type="text/javascript" src="https://api.map.baidu.com/api?v=2.0&ak=<?php echo BDMAPKEY; ?>"></script>
		<script>
			var map;
			var geolocation = new BMap.Geolocation();
			var geoLat,geoLng;
			
			function initMap(){
				map = new BMap.Map("localMap");
				var point = new BMap.Point(116.331398,39.897445);
				map.enableScrollWheelZoom();
				 
				map.centerAndZoom(point,18);
				console.log("why")	
			}
			function getGps(){
				geolocation.getCurrentPosition(function(r){
					if(this.getStatus() == BMAP_STATUS_SUCCESS){
						geoLat=r.point.lat;
						geoLng=r.point.lng;
					}
					else {
						alert('failed'+this.getStatus());
					}        
				},{enableHighAccuracy: true})
			}
			function mapGps(){
				
				geolocation.getCurrentPosition(function(r){
					if(this.getStatus() == BMAP_STATUS_SUCCESS){
						var mk = new BMap.Marker(r.point);
						map.addOverlay(mk);
						map.panTo(r.point);
						geoLat=r.point.lat;
						geoLng=r.point.lng;
						//alert('您的位置：'+r.point.lng+','+r.point.lat);
					}
					else {
						alert('failed'+this.getStatus());
					}        
				},{enableHighAccuracy: true})
			}
			//获取gps
			getGps();
		</script>
		<script src="<?php echo $this->_var['skins']; ?>index.js?vaaasd"></script>
		<?php wx_jssdk()?>
		<script>
			wxshare_title="福鼎拼车帮助提升乡镇交通便利";
		</script>
	</body>
</html>
