<?php

/**
 * 项目扩展函数库
 * @author bant
 */
//引入定制项目公用方法
include COMMON_PATH . 'customCommon.php';
//TODO: 此文件需要整理

/**
 * 类实例化
 * @staticvar array $_services      缓存类
 * @param type $className           类的名称
 * @param type $domain              类的类型
 * @param type $pathOrModule        路径或模块名称，为空时如果在Lib/Service加载不到，会尝试在$serviceName对应模块下进行加载
 * @return boolean|\class           失败返回FALSE，成功返回类的实例化对象
 */
function BCall($className, $domain = 'Service', $pathOrModule = '') {
    $classSuffix = $domain; //类后缀
    $className = ucfirst($className); //首字母大写，命名规范

    static $_services = array();
    $key = $className . '_' . $domain . '_' . $pathOrModule;
    if (!isset($_services[$key]) || $_services[$key] === NULL) {
        $class = $className . $classSuffix;
        // 如果$pathOrModule有值，就不去搜索Lib/Service目录了
        if ($pathOrModule || !import("$domain.$class", LIB_PATH)) {
            $path = is_dir($pathOrModule) ? $pathOrModule : APP_PATH . C('APP_GROUP_PATH') . DS . (empty($pathOrModule) ? $className : $pathOrModule);
            import("$domain.$class", $path);
        }
        //实例化
        if (class_exists($class)) {
            $object = new $class();
            unset($class);
            $_services[$key] = $object;
        } else {
            $_services[$key] = FALSE;
        }
    }
    return $_services[$key];
}

/**
 * 调用Service
 * @param type $serviceName     Service 名称
 * @param type $pathOrModule    路径或模块名称，为空时如果在Lib/Service加载不到，会尝试在$serviceName对应模块下进行加载
 * @return type
 */
function BService($serviceName, $pathOrModule = '') {
    return BCall($serviceName, 'Service', $pathOrModule);
}

/**
 * 获取当前页面完整URL地址
 * @return type 
 */
function getCurrentUrl() {
    $sys_protocal = isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443' ? 'https://' : 'http://';
    $php_self = $_SERVER['PHP_SELF'] ? safe_replace($_SERVER['PHP_SELF']) : safe_replace($_SERVER['SCRIPT_NAME']);
    $path_info = isset($_SERVER['PATH_INFO']) ? safe_replace($_SERVER['PATH_INFO']) : '';
    $relate_url = isset($_SERVER['REQUEST_URI']) ? safe_replace($_SERVER['REQUEST_URI']) : $php_self . (isset($_SERVER['QUERY_STRING']) ? '?' . safe_replace($_SERVER['QUERY_STRING']) : $path_info);
    return $sys_protocal . (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '') . $relate_url;
}

/**
 * 分页方法
 * @param type $totalRows       总条目
 * @param type $listRows        每页显示条目数
 * @param type $nowPage         当前页数 为空默认取$_GET[C('VAR_PAGE')]
 * @param type $parameter       分页参数
 * @param type $url             分页URL
 * @return \Page
 */
function page($totalRows, $listRows = '', $nowPage = '', $parameter = '', $url = '') {
    import('Page');
    if (empty($listRows)) {
        $listRows = C('PAGE_LISTROWS');
    }
    $page = new Page($totalRows, $listRows, $parameter, $url, $nowPage);
    $page->config('theme', '<strong>%totalRow%</strong> %header%&nbsp;│&nbsp;<strong>%nowPage%</strong> / %totalPage% 页&nbsp;│&nbsp;%first% %upPage% %prePage%%linkPage% %nextPage% %downPage% %end%');
    return $page;
}

/**
 * 填充数组指定键值为数组的下标
 * @param type $array 目标数据
 * @param type $indexField 数组指定key
 * @return boolean
 */
function setArrayIndexByKey($array, $indexField = NULL) {
    $newArray = array();
    if (!is_array($array)) {
        return false;
    }
    if (is_null($indexField)) {
        foreach ($array as $value) {
            $newArray[$value] = $value;
        }
    } else {
        foreach ($array as $value) {
            $newArray[$value[$indexField]] = $value;
        }
    }
    return $newArray;
}

/**
 * 检测是否http/https地址
 * @param type $string
 */
function isHttpUrl($string) {
    return preg_match('/^(http|https):\/\//', $string);
}

/**
 * 返回随机数
 * @param type $length 随机数长度
 * @param type $numeric 是否只为数字
 * @return type String
 */
function random($length, $numeric = 0) {
    $string = base_convert(md5(microtime() . $_SERVER['DOCUMENT_ROOT']), 16, $numeric ? 10 : 35);
    $seed = $numeric ? (str_replace('0', '', $seed) . '012340567890') : ($string . 'zZ' . strtoupper($string));
    $hash = '';
    $max = strlen($seed) - 1;
    for ($i = 0; $i < $length; $i++) {
        $hash .= $seed{mt_rand(0, $max)};
    }
    return $hash;
}

/**
 * 根据UID划分目录
 * @param type $uid
 */
function uidDivideDir($uid) {
    $uid = sprintf('%09d', abs(intval($uid)));
    $dir1 = substr($uid, 0, 3);
    $dir2 = substr($uid, 3, 2);
    $dir3 = substr($uid, 5, 2);
    return $dir1 . '/' . $dir2 . '/' . $dir3 . '/' . substr($uid, -2) . '/';
}

/**
 * 删除目录下所有文件
 * @param type $dir         需要删除文件的目录
 * @param type $deleteDir   是否遍历子目录
 * @return boolean          如果没有错误，则返回TRUE
 */
function deleteDir($dir, $deleteDir = TRUE) {
    if (is_dir($dir) && FALSE !== ($handle = opendir($dir))) {
        while (FALSE !== ($fileName = readdir($handle))) {
            if (!in_array($fileName, array('.', '..'))) {
                $filePath = $dir . DS . $fileName;
                if (is_file($filePath)) {
                    @unlink($filePath);
                } else if ($deleteDir) {
                    deleteDir($filePath, $deleteDir);
                }
            }
        }
        closedir($handle);
        $deleteDir && rmdir($dir);
        return TRUE;
    }
    return FALSE;
}

/**
 * 根据UID获取头像
 * @param type $uid
 * @return type
 */
function getUserAvatar($uid, $type = 'url') {
    return BService('Member')->getUserAvatar($uid, $type);
}

/**
 * 取得URL地址中域名部分
 * @param type $url 
 * @return \url 返回域名
 */
function urlDomain($url) {
    if ($url) {
        $pathinfo = parse_url($url);
        return $pathinfo['scheme'] . "://" . $pathinfo['host'] . "/";
    }
    return false;
}

/**
 * 获取前台模版路径
 * @param string $templateAction        模版ACTION，兼容'Theme:Group:Module:Action'方式
 * @param string $templateModule        模版MODULE
 * @param string $templateGroup         模版分组
 * @param type $templateTheme           模版主题
 * @return string                       失败抛出错误，成功返回模版路径
 */
function getFrontTemplateFile($templateAction = '', $templateModule = '', $templateGroup = '', $templateTheme = '') {
    if (is_file($templateAction)) {
        return $templateAction;
    }

    // 支持旧方法
    $explode = array_reverse(explode(':', $templateAction));
    if (count($explode) > 1) {
        $templateAction = $explode[0];
        empty($templateModule) && $templateModule = $explode[1];
        empty($templateGroup) && $templateGroup = $explode[2];
        empty($templateTheme) && $templateTheme = $explode[3];
    }

    $theme = BaseAction::getVar('config/theme');
    empty($templateTheme) && $templateTheme = $theme ? $theme : C('FRONT_TMPL_DEFAULT_THEME');
    empty($templateGroup) && $templateGroup = GROUP_NAME;
    empty($templateModule) && $templateModule = MODULE_NAME;
    empty($templateAction) && $templateAction = ACTION_NAME;

    $templateFile = TEMPLATE_PATH . $templateTheme . DS . 'Tpl' . DS . $templateGroup . DS . $templateModule . DS . $templateAction . C('TMPL_TEMPLATE_SUFFIX');
    if (!file_exists_case($templateFile)) {
        //记录日志
        if (APP_DEBUG) {
            Log::write('模板:[' . $templateFile . ']不存在');
        }
        throw_exception(L('_TEMPLATE_NOT_EXIST_') . '[' . $templateFile . ']');
    }
    return $templateFile;
}

/**
 * 遍历获取模版列表
 * @param type $templateModule      模版Module。支持传入模版路径获取列表
 * @param type $templateGroup       模版分组
 * @param type $templateTheme       模版主题
 * @return type                     返回模版列表
 */
function getFrontTemplateList($templateModule = '', $templateGroup = '', $templateTheme = '') {
    $templatePath = '';
    // 支持第一个参数就是路径
    if (is_dir($templateModule) && FALSE !== strpos($templateModule, TEMPLATE_PATH)) {
        $templatePath = rtrim($templateModule, '\/\\') . DS;
    } else {
        $theme = BaseAction::getVar('config/theme');
        empty($templateTheme) && $templateTheme = $theme ? $theme : C('FRONT_TMPL_DEFAULT_THEME');
        empty($templateGroup) && $templateGroup = C('DEFAULT_GROUP');
        empty($templateModule) && $templateModule = C('DEFAULT_MODULE');
        $templatePath = TEMPLATE_PATH . $templateTheme . DS . 'Tpl' . DS . $templateGroup . DS . $templateModule . DS;
    }

    $templateList = array();
    if (is_dir($templatePath)) {
        foreach (glob($templatePath . DS . '*' . C('TMPL_TEMPLATE_SUFFIX')) as $templateFile) {
            if (is_file($templateFile)) {
                $pathinfo = pathinfo($templateFile);
                $templateList[$pathinfo['filename']] = $pathinfo['basename'];
            }
        }
    }
    return $templateList;
}

/**
 * 生成SEO
 * @param $categoryId   栏目ID
 * @param $title        标题
 * @param $description  描述
 * @param $keyword      关键词
 */
function seo($categoryId = '', $title = '', $description = '', $keyword = '') {
    $categoryId = intval($categoryId);
    if (!empty($title)) {
        $title = bpiHtmlspecialchars($title);
    }
    if (!empty($description)) {
        $description = bpiHtmlspecialchars($description);
    }
    if (!empty($keyword)) {
        $keyword = str_replace(' ', ',', bpiHtmlspecialchars($keyword));
    }

    $site = FData('Config');
    $categoryCache = FData('Category');

    $category = isset($categoryCache[$categoryId]) ? $categoryCache[$categoryId] : array();
    $seo['site_title'] = $site['site_name'];
    //标题
    $seo['title'] = '';
    if (isset($title) && !empty($title)) {
        $seo['title'] = $title . ' - ';
    }
    if (isset($category['setting']['meta_title']) && !empty($category['setting']['meta_title'])) {
        $seo['title'] .= $category['setting']['meta_title'] . ' - ';
    }
    if (isset($category['category_name']) && !empty($category['category_name'])) {
        $seo['title'] .= $category['category_name'] . ' - ';
    }
    //简介
    $seo['description'] = '';
    if (isset($description) && !empty($description)) {
        $seo['description'] = $description;
    } else if (isset($category['setting']['meta_description']) && !empty($category['setting']['meta_description'])) {
        $seo['description'] = $category['setting']['meta_description'];
    } else if (isset($site['site_summary']) && !empty($site['site_summary'])) {
        $seo['description'] = $site['site_summary'];
    }
    //关键字
    $seo['keyword'] = '';
    if (isset($keyword) && !empty($keyword)) {
        $seo['keyword'] = $keyword;
    } else if (isset($category['setting']['meta_keywords']) && !empty($category['setting']['meta_keywords'])) {
        $seo['keyword'] = $category['setting']['meta_keywords'];
    } else if (isset($site['site_keyword']) && !empty($site['site_keyword'])) {
        $seo['keyword'] = $site['site_keyword'];
    }

    foreach ($seo as $k => $v) {
        $seo[$k] = str_replace(array("\n", "\r"), '', $v);
    }
    return $seo;
}

/**
 * 字符串截取，支持中文和其他编码
 * @param string $string 需要转换的字符串
 * @param string $start 开始位置
 * @param string $length 截取长度
 * @param string $suffix 截断显示字符
 * @param string $charset 编码格式
 * @return string
 */
function cutString($string, $start = 0, $length = 0, $suffix = FALSE, $charset = NULL) {
    $charset = isset($charset) ? $charset : C('DEFAULT_CHARSET');
    return String::msubstr($string, $start, $length, $charset, $suffix);
}

/**
 * 全局参数过滤函数
 * @param type $str
 * @notice 这里被ThinkPHP 全局过滤调用, 必须使用引用符 
 */
function bpiHtmlspecialchars(&$str) {
    return $str = htmlspecialchars($str, ENT_QUOTES);
}

/**
 * 把一些预定义的 HTML 实体转换为字符(同时解码双引号和单引号)
 * @param type $str
 */
function bpiHtmlspecialcharsDecode($str) {
    return htmlspecialchars_decode($str, ENT_QUOTES);
}

/**
 * 排列组合的函数
 * @param type $elements    传入需要排列组合的数组
 * @return boolean          返回所有排列组合的数组
 */
function combinations($elements) {
    if (is_array($elements)) {
        $combinations = array(array());
        foreach ($elements as $element) {
            $new_combinations = array();
            foreach ($combinations as $combination) {
                $new_combination = array_merge($combination, array($element));
                array_push($new_combinations, $new_combination);
            }
            $combinations = array_merge($combinations, $new_combinations);
        }
        return $combinations;
    } else {
        return false;
    }
}

/**
 * 获取常用正则表达式列表
 */
function getRegularList() {
    $regularList = array(
        'double' => array('name' => '双精度数字', 'regular' => '/^[-\+]?\d+(\.\d+)?$/'),
        'integer' => array('name' => '整数', 'regular' => '/^[-\+]?\d+$/'),
        'english' => array('name' => '纯字母', 'regular' => '/^[A-Za-z]+$/'),
        'int&englist' => array('name' => '数字+字母', 'regular' => '/^[0-9A-Za-z]+$/'),
        'tel' => array('name' => '手机号码', 'regular' => '/^(1)[0-9]{10}$/'),
        'email' => array('name' => 'Email', 'regular' => "/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/i"),
        'zip' => array('name' => '邮编地址', 'regular' => '/^[1-9]\d{5}$/'),
        'url' => array('name' => '链接', 'regular' => "/^((([A-Za-z]{3,9}:(?:\/\/)?)(?:[-;:&=\+\$,\w]+@)?[A-Za-z0-9.-]+|(?:www.|[-;:&=\+\$,\w]+@)[A-Za-z0-9.-]+)((?:\/[\+~%\/.\w-_]*)?\??(?:[-\+=&;%@.\w_]*)#?(?:[\w]*))?)$/"),
    );

    foreach ($regularList as &$regular) {
        bpiHtmlspecialchars($regular['regular']);
    }
    return $regularList;
}

/**
 * 将服务器文件路径转换成url
 * @param type $filePath
 * @return type
 */
function filePathToUrl($filePath) {
    return urlToFilePath($filePath, true);
}

/**
 * 将本站文件url格式化转换成服务器本地路径
 * @param type $uri 资源识别位置，url or localpath
 * @param type $isReverse 是否逆转，true表示filepath to url
 * @return type
 */
function urlToFilePath($uri, $isReverse = false) {
    if ($isReverse) {
        return str_replace('\\', '/', BaseAction::getVar('config/site_upload_url') . str_replace(C('UPLOAD_PATH'), '', $uri));
    } else {
        return C('UPLOAD_PATH') . str_replace(BaseAction::getVar('config/site_upload_url'), '', $uri);
    }
}

/**
 * 封装的cookie读写方法
 * @param type $name
 * @param type $value
 * @param type $option
 * @return type
 */
function BCookie($name, $value = '', $option = NULL) {
    if (isset($name)) {
        if ('' === $value) {//获取指定cookie
            return authcode(cookie($name), 'DECODE', C('AUTH_CODE'));
        } elseif (is_null($value)) {//删除指定cookie
            cookie($name, NULL);
        } else {//设置cookie
            $expiryTime = intval($option);
            cookie($name, authcode($value, '', C('AUTH_CODE'), $expiryTime), $option);
        }
    } else {
        //删cookie
        cookie(NULL, $value, $option);
    }
}

/**
 * 加密解密
 * @param type $string 明文 或 密文  
 * @param type $operation DECODE表示解密,其它表示加密  
 * @param type $key 密匙  
 * @param type $expiry 密文有效期  
 * @return string 
 */
function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {

    // 动态密匙长度，相同的明文会生成不同密文就是依靠动态密匙
    $ckey_length = 4;
    // 密匙
    $key = md5(($key ? $key : C("AUTHCODE")));
    // 密匙a会参与加解密
    $keya = md5(substr($key, 0, 16));
    // 密匙b会用来做数据完整性验证
    $keyb = md5(substr($key, 16, 16));
    // 密匙c用于变化生成的密文
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length) : substr(md5(microtime()), -$ckey_length)) : '';
    // 参与运算的密匙
    $cryptkey = $keya . md5($keya . $keyc);
    $key_length = strlen($cryptkey);
    // 明文，前10位用来保存时间戳，解密时验证数据有效性，10到26位用来保存$keyb(密匙b)，解密时会通过这个密匙验证数据完整性
    // 如果是解码的话，会从第$ckey_length位开始，因为密文前$ckey_length位保存 动态密匙，以保证解密正确  
    $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
    $string_length = strlen($string);
    $result = '';
    $box = range(0, 255);
    $rndkey = array();
    // 产生密匙簿
    for ($i = 0; $i <= 255; $i++) {
        $rndkey[$i] = ord($cryptkey[$i % $key_length]);
    }
    // 用固定的算法，打乱密匙簿，增加随机性，好像很复杂，实际上对并不会增加密文的强度
    for ($j = $i = 0; $i < 256; $i++) {
        $j = ($j + $box[$i] + $rndkey[$i]) % 256;
        $tmp = $box[$i];
        $box[$i] = $box[$j];
        $box[$j] = $tmp;
    }
    // 核心加解密部分
    for ($a = $j = $i = 0; $i < $string_length; $i++) {
        $a = ($a + 1) % 256;
        $j = ($j + $box[$a]) % 256;
        $tmp = $box[$a];
        $box[$a] = $box[$j];
        $box[$j] = $tmp;
        // 从密匙簿得出密匙进行异或，再转成字符
        $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }
    if ($operation == 'DECODE') {
        // substr($result, 0, 10) == 0 验证数据有效性
        // substr($result, 0, 10) - time() > 0 验证数据有效性  
        // substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16) 验证数据完整性  
        // 验证数据有效性，请看未加密明文的格式  
        if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
            return substr($result, 26);
        } else {
            return '';
        }
    } else {
        // 把动态密匙保存在密文里，这也是为什么同样的明文，生产不同密文后能解密的原因
        // 因为加密后的密文可能是一些特殊字符，复制过程可能会丢失，所以用base64编码  
        return $keyc . str_replace('=', '', base64_encode($result));
    }
}

/**
 * importAction函数用于引入Action文件 格式：[项目://][分组/]模块
 * @param string $name Action资源地址
 * @param string $layer 控制层名称
 * @param boolean $common 是否公共目录
 * @return Action|false
 */
//2013-11-5 11:46:11 废弃 bant
//function importAction($name, $layer = '', $common = false) {
//    static $_action = array();
//    $layer = $layer ? $layer : C('DEFAULT_C_LAYER');
//    if (strpos($name, '://')) {// 指定项目
//        $name = str_replace('://', '/' . $layer . '/', $name);
//    } else {
//        $name = '@/' . $layer . '/' . $name;
//    }
//    if (isset($_action[$name]))
//        return $_action[$name];
//    $path = explode('/', $name);
//    if (count($path) > 3 && 1 == C('APP_GROUP_MODE')) { // 独立分组
//        $baseUrl = $path[0] == '@' ? dirname(BASE_LIB_PATH) : APP_PATH . '../' . $path[0] . '/' . C('APP_GROUP_PATH') . '/';
//        return import($path[2] . '/' . $path[1] . '/' . $path[3] . $layer, $baseUrl);
//    } elseif ($common) { // 加载公共类库目录
//        return import(str_replace('@/', '', $name) . $layer, LIB_PATH);
//    } else {
//        return import($name . $layer);
//    }
//}

/**
 * 获取附件地址
 * @param type $AttachmentId    附件ID
 * @return string   附件地址
 */
function getAttachmentUrl($attachmentId) {
    if (!$attachmentId) {
        return '';
    }
    $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
    return isset($attachmentInfo['file_url']) ? $attachmentInfo['file_url'] : '';
}

/**
 * 根据hash获取附件地址
 * @param type $AttachmentId    附件ID
 * @return string   附件地址
 */
function getAttachmentUrlByHash($attachmentHash) {
    if (!$attachmentHash) {
        return '';
    }
    $attachmentInfo = BService('Attachment')->getAttachmentInfoByHash($attachmentHash);
    return isset($attachmentInfo['file_url']) ? $attachmentInfo['file_url'] : '';
}

/**
 * 根据附件相对路径获取附件链接地址
 * @param type $filePath    附件相对路径
 * @return type             附件链接地址
 */
function getAttachmentSiteUrl($filePath) {
    if (empty($filePath)) {
        return '';
    } else {
        $pathUrl = C('UPLOAD_FILE_PATH') . $filePath;
        return filePathToUrl($pathUrl);
    }
}

/**
 * 根据附件id获取二维码路径
 * @param type $attachmentId
 * @return type
 */
function getAttachmentQRCode($attachmentId) {
    $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
    return $attachmentInfo['qrcode_path'] ? filePathToUrl(C('UPLOAD_QRCODE_PATH') . $attachmentInfo['qrcode_path']) : '';
}

/**
 * 根据附件id获取hash
 * @param type $attachmentId
 * @return type
 */
function getAttachmentHash($attachmentId) {
    $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
    return $attachmentInfo['hash'] ? $attachmentInfo['hash'] : '';
}

/**
 * 获取格式化后的时间
 * @param type $timeData 待处理的时间
 * @param type $type 类型
 * @param type $isReverse 是否逆转
 * @return type
 */
function getFormatTime($timeData, $type, $isReverse = false) {
    $returnTime = '';
    switch ($type) {
        case 'timeWithoutDayTime'://获取去除当日时间的时间戳
            $dayTime = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
            $returnTime = $isReverse ? $timeData + $dayTime : $timeData - $dayTime;
            break;
        default:
            $returnTime = $timeData;
            break;
    }
    return $returnTime;
}

/**
 * 获取前台用户/后台管理员帐号
 * @param type $uid         uid
 * @param type $isAdmin     是否为管理员
 * @return string           帐号
 */
function getUserNameById($uid = 0, $isAdmin = false) {
    if (!$uid) {
        return '游客';
    }
    if ($isAdmin) {
        $info = BService('Admin')->getAdminById($uid);
    } else {
        $info = BService('Member')->getMemberById($uid);
    }
    return isset($info['user_name']) ? $info['user_name'] : '游客';
}

/**
 * 附件上传参数加密
 * @param type $str 参数字符串
 */
function uploadAuth($str) {
    $auth = 'quodamzcpasdasd2as';
    $authKey = md5($auth . $_SERVER['HTTP_USER_AGENT']);
    return md5($str . $authKey);
}

/**
 * 对二维数组按照某一值排序
 * @param type $array   二维数组
 * @param type $key     键名
 * @param type $desc    是否递减
 */
function sortArrayByKey($array, $key = 'sort', $desc = true) {
    $temp = array();
    foreach ($array as $k => $v) {
        $temp[$k] = $v[$key];
    }
    $function = $desc ? 'arsort' : 'asort';
    $function($temp);
    foreach ($temp as $k => $v) {
        $temp[$k] = $array[$k];
    }
    return $temp;
}

/**
 * 整合获取树形函数
 * @param type $data            数据
 * @param type $string          树形基本结构(HTML语句)
 * @param type $selected        被选中数值(select标签)
 * @param type $id              表示获取这个id下的所有字段
 * @param type $icon            分隔符
 * @param type $nbsp            空格符
 * @param type $addString       $spacer附加字符串
 * @param type $returnString    返回附加字符串($data有效时才返回)
 * @return string
 */
function getTree($data, $string, $selected = 0, $id = 0, $icon = array('&nbsp;│ ', '&nbsp;├─ ', '&nbsp;└─ '), $nbsp = '&nbsp;', $addString = '', $returnString = '') {
    import('Tree');
    $tree = new Tree();
    $tree->icon = $icon;
    $tree->nbsp = $nbsp;
    $tree->init($data);
    return $tree->get_tree($id, $string, $selected, $addString, $returnString);
}

/**
 * 获取utf8字符串长度
 * @param type $string  字符串
 * @return int          字符串长度(1个汉字算1个长度)
 */
function utf8StringLength($string) {
    $i = 0;
    $count = 0;
    $length = strlen($string);
    while ($i < $length) {
        $chr = ord($string[$i]);
        $count++;
        $i++;
        if ($i >= $length)
            break;
        if ($chr & 0x80) {
            $chr <<=1;
            while ($chr & 0x80) {
                $i++;
                $chr <<=1;
            }
        }
    }
    return $count;
}

/**
 * 通过PHPMailer发送邮件
 * @param type $address     收件人Email地址，可以为数组array('address' => 'xxx', 'name' => 'xxxx')形式
 * @param type $title       邮件标题
 * @param type $content     邮件内容，支持HTML
 * @return boolean          返回是否发送成功
 */
function sendMail($address, $title, $content) {
    $config = BaseAction::getVar('config');

    if (1 !== intval($config['mail_type'])) {
        return FALSE;
    }

    import('PHPMailer');
    $mail = new PHPMailer;
    // 设置发送HTML
    $mail->IsHTML();
    // 设置邮件格式
    $mail->CharSet = C('DEFAULT_CHARSET');
    // 添加收件人信息
    if (is_array($address)) {
        $mail->AddAddress($address['address'], $address['name']);
    } else {
        $mail->AddAddress($address);
    }

    $mail->SetFrom($config['mail_from_address'], $config['mail_from_name']);
    // 设置标题内容
    $mail->Subject = $title;
    $mail->Body = $content;

    // SMTP服务器配置
    $mail->IsSMTP();
    $mail->Host = $config['mail_smtp_server'];
    $mail->Port = $config['mail_smtp_port'];

    if (($mail->SMTPAuth = (bool) $config['mail_auth'])) {
        $mail->Username = $config['mail_username'];
        $mail->Password = $config['mail_password'];
    }

    $result = $mail->Send();
    if (!$result) {
        BService('Log')->addOperateLog(BaseAction::getVar('user_id'), BaseAction::getVar('user_name'), '新增', $mail->ErrorInfo, $address);
    } else {
        BService('Log')->addOperateLog(BaseAction::getVar('user_id'), BaseAction::getVar('user_name'), '新增', '发送邮件成功', $address);
    }
    return $result;
}

/**
 * 数据字段过滤
 * @param type $data            需要过滤的数据
 * @param type $filterField     过滤的字段，支持逗号分隔字符串和数组形式
 * @param type $isIntersect     为TRUE代表数据与过滤字段的交集，为FALSE代表数据不包含过滤字段
 * @return type
 */
function dataFilter($data, $filterField, $isIntersect = TRUE) {
    if (!is_array($data) || empty($data) || empty($filterField)) {
        return array();
    }

    if (!is_array($filterField)) {
        $filterField = explode(',', $filterField);
    }

    $intersectData = array_intersect_key(array_flip($filterField), $data);
    if (!$isIntersect) {
        return array_diff_key($data, $intersectData);
    }
    return $intersectData;
}

/**
 * 返回响应地址
 */
function return_url($code, $is_api = 0) {
    if ($is_api) {
        return SITE_URL . 'index.php?g=Payment&m=Payment&a=respond&code=' . $code;
    } else {
        return SITE_URL . 'index.php?g=Payment&m=Payment&a=respond&code=' . $code;
    }
}

/**
 * 用此方法代替使用F方法，确保数据不会为空
 * @param type $dataName        数据名
 * @param type $model           模型名
 * @param type $module          模块名
 * @param type $forceUpdate     是否强制更新
 * @param type $function        更新数据方法名
 * @return array
 */
function FData($dataName, $model = '', $module = '', $forceUpdate = false, $function = 'updateCache') {
    if (F($dataName) && !$forceUpdate) {
        return F($dataName);
    }
    $model = $model === '' ? $dataName : $model;
    if ($module) {
        $instantiateModel = D($module . '/' . $model);
    } else {
        $instantiateModel = D($model);
    }

    if (method_exists($instantiateModel, $function)) {
        @call_user_func(array($instantiateModel, $function));
    }
    return F($dataName);
}

/**
 * 隐藏IP地址的最后一位
 * @param type $ip  IP地址
 * @return string   处理后的IP地址
 */
function hideTheLastOneIp($ip) {
    $ipArray = explode('.', $ip);
    if (!is_array($ipArray)) {
        return '';
    }
    if (isset($ipArray[3])) {
        $ipArray[3] = '*';
    }
    $returnIp = implode(".", $ipArray);
    return $returnIp;
}

/**
 * 字节格式化单位
 * @param type $size    字节数
 * @return string       格式化单位后的容量
 */
function formatSize($size) {
    if ($size >= 1073741824) {
        $size = round($size / 1073741824 * 100) / 100 . ' GB';
    } else if ($size >= 1048576) {
        $size = round($size / 1048576 * 100) / 100 . ' MB';
    } else if ($size >= 1024) {
        $size = round($size / 1024 * 100) / 100 . ' KB';
    } else {
        $size = $size . ' Bytes';
    }
    return $size;
}

/**
 * @param string $str 需要转换的字符串
 * @param string $version 版本号
 * @param string $dict 字典
 * @return boolean
 */
function get_keywords_str($string, $version = '3', $dict = 'xdb', $autodis = true, $ignore = true, $debug = false, $stats = false) {
    //编码自动转出GBK
    Load('extend');
    $string = auto_charset($string, $from = 'utf-8', $to = 'gbk');
    if ($dict == 'gdbm') {
        $dictdb = LIB_PATH . 'ORG/pscws/dict/dict.gdbm';
    } elseif ($dict == 'text') {
        $dictdb = LIB_PATH . 'ORG/pscws/dict/dict.text';
    } elseif ($dict == 'sqlite') {
        $dictdb = LIB_PATH . 'ORG/pscws/dict/dict.sqlite';
    } elseif ($dict == 'cdb') {
        $dictdb = LIB_PATH . 'ORG/pscws/dict/dict.cdb';
    } else {
        $dictdb = LIB_PATH . 'ORG/pscws/dict/dict.xdb';
    }

    $object = 'PSCWS' . $version;
    require (LIB_PATH . 'ORG/pscws/' . strtolower($object) . '.class.php');
    $cws = new $object($dictdb);
    $cws->set_ignore_mark($ignore);
    $cws->set_autodis($autodis);
    $cws->set_debug($debug);
    // hightman.060330: 强行开启统计
    $cws->set_statistics($stats);
    $res = $cws->segment(trim($string));
    //将数组转换成字符串
    $strs = '';
    foreach ($res as $tmp) {
        if ($tmp == "\n") {
            $strs .= $tmp;
            continue;
        }
        $strs .= $tmp . ' ';
    }
    return auto_charset($strs, $from = 'gbk', $to = 'utf-8');
}
/**
 * 获取前台主题
 * @return type
 */
function getFrontTheme() {
    //默认主题风格
    $defaultTheme = BaseAction::getVar('config/theme');
    $frontTheme = $defaultTheme ? $defaultTheme : C('FRONT_TMPL_DEFAULT_THEME');
    return $frontTheme;
}

/**
 * 获取模型id
 * @param type $modelIdentify   模型标识，int为id，string为name
 * @param type $modelType       模型类型
 * @return type
 */
function getModelId($modelIdentify, $modelType = null) {
    if (is_numeric($modelIdentify)) {
        return $modelIdentify;
    } else {
        $modelType = $modelType ? $modelType : C('MODEL_TYPE.CONTENT');
        return D('Model')->getModelIdByModelName($modelIdentify, $modelType);
    }
}
/**
 * 获取程序下载url
 * @param type $applicationId
 * @return type
 */
function getApplicationDownloadUrl($applicationId) {
    $applicationId = intval($applicationId);
    $applicationInfo = BService('Application', 'Market')->getApplicationById($applicationId, NULL, NULL, true, TRUE);
    $modelName = D('Model')->getModelTableName($applicationInfo['model_id'], false, true);
    //下载链接
    $downloadUrl = NULL;
    $downloadInfo = current(unserialize($applicationInfo['download_url']));
    $attachmentInfo = BService('Attachment')->getAttachmentInfo($downloadInfo['attachment_id']);
    if ($attachmentInfo) {
        $downloadUrl = U('Index/Download/downloadApplication', array(
            'id' => $applicationInfo['id'],
            'category_id' => $applicationInfo['category_id'],
            'url' => urlencode($attachmentInfo['file_url']),
            'mn' => $modelName,
                ), null, null, true);
    }
    return $downloadUrl;
}

?>
