<?php

/**
 * 常量配置
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
return array(
    /* 栏目模块 */
    //栏目分类
    'CATEGORY_TYPE' => array(
        'NORMAL' => 0, // 一般栏目
        'SINGLE_SITE' => 1, // 单网页
        'CHAIN' => 2, // 外链
        'TOPIC' => 10, //专题
    ),
    // 栏目角色权限设置
    'CATEGORY_ROLE_PURVIEW_ACTION_LIST' => array(
        'INDEX' => 'index',
        'ADD' => 'add',
        'EDIT' => 'edit',
        'DELETE' => 'delete',
        'SORT' => 'sort',
        'PUSH' => 'push',
        'MOVE' => 'move'
    ),
    // 栏目用户组权限设置
    'CATEGORY_MEMBER_PURVIEW_ACTION_LIST' => array(
        'ADD' => 'add',
    ),
    /* 模型模块 */
    /* 模型字段处理函数入库时间点类型 */
    'MODEL_FIELD_FUNCTION_RUN_TIME' => array(
        'BEFORE' => 1,
        'AFTER' => 2,
        'ALL' => 3,
    ),
    /* 内容模块 */
    /* 附件模块 */
    /* 日志记录操作常量 */
    'OPERATE_TYPE' => array(
        'OPERATE_ADD' => '新增',
        'OPERATE_UPDATE' => '更新',
        'OPERATE_DELETE' => '删除',
    ),
    /* AJAX数据回调操作值 */
    'JAVASCRIPT_TYPE' => array(
        'URL' => 'window.location.href =',
        'REFRESH' => 'window.location.reload();',
        'RETURNLIST' => 'var url = $(".return_btn a").attr("href"); url ? window.location.href = url : window.location.reload();',
    ),
    /* 关键字类型 */
    'FILTERWORD_TYPE' => array(
        'FILTERWORD_REPLACE' => 1, //替换
        'FILTERWORD_FORBIDDEN' => 2, //禁用
        'FILTERWORD_AUDIT' => 3, //审核
    ),
    /* 点击统计类型前缀 */
    'HIT_TYPE_PREFIX' => array(
        'CATEGORY' => 'c', //栏目
    ),
    /* 点击统计标识 */
    'HIT_FLAG' => array(
        'HIT' => 1, //点击标识
        'DOWNLOAD' => 10, //下载标识
    ),
    /* 点击排序类型 */
    'HIT_ORDER_TYPE' => array(
        'TOTAL' => 'total',
        'MONTH' => 'month',
        'WEEK' => 'week',
        'DAY' => 'day',
        'YESTERDAY' => 'yesterday',
    ),
    /* 生成静态 */
    'GENERATE_TYPE' => array(
        'GENERATE_INDEX' => array(1 << 0, '首页'), // 生成首页
        'GENERATE_CATEGORY' => array(1 << 1, '当前栏目'), // 生成当前栏目
        'GENERATE_PARENT_CATEGORY' => array(1 << 2, '父栏目'), // 生成父栏目
    ),
	/**
     * 关联类型，如需要补充新增模块下的类型，格式:模块名.类型名;
     * 或者customConstant增加ACCESS_TYPE_EXT
     * 'ACCESS_TYPE_EXT'=>array('类型名'=>'模块名.类型名')
     */
    'ACCESS_TYPE' => array(
        'SITE' => 'Site',
        'CATEGORY' => 'Category',
        'CONTENT' => 'Content',
        'POSITION' => 'Position',
        'MEMBER_GROUP' => 'MemberGroup',
        'APPLICATION' => 'Market.Application'
    ),
    /* 附件标识 */
    'ATTACHMENT_FLAG' => array(
        'ATTACHMENT' => 1, // 附件标识
        'THUMB' => 2, // 缩略图标识
        'SCREENSHOT' => 3, //截图
        'IMAGE' => 4, //图片
        'ICON' => 5, //图标
        'EDITOR_IMAGE' => 10, //编辑器图片
    ),
    /* ACTION NAME 类型列表 */
    'ACTION_TYPE' => array(
        'ADD' => 'add',
        'EDIT' => 'edit',
        'DELETE' => 'delete',
    ),
    /* 验证码类型类表 */
    'VERIFY_TYPE' => array(
        'ADMIN_LOGIN' => 'admin_login', //后台用户登录
        'MEMBER_REGISTER' => 'member_register', //会员中心注册
        'MEMBER_LOGIN' => 'member_login', //会员中心登录
        'COMMENT' => 'comment_verify', //评论 
    ),
    /* 模型类型 */
    'MODEL_TYPE' => array(
        'CONTENT' => 0, //内容模型
        'MEMBER' => 2, //会员模型
        'COMMENT' => 4, //评论模型
        'APPLICATION' => 6, //应用模型
    ),
    /* 内容审核状态列表 */
    'CONTENT_CHECK_STATUS' => array(
        'PASS' => 99, //内容通过审核
        'NORMAL' => 1, //内容需要审核
    ),
    /* URL规则类型 */
    'URL_RULE_TYPE' => array(
        'INDEX' => 1,
        'CATEGORY' => 2,
        'CONTENT' => 3,
        'TAG' => 4
    ),
    /* 会员头像生成尺寸 */
    'MEMBER_AVATAR_SIZE' => array(
        180 => '180.jpg',
        90 => '90.jpg',
        45 => '45.jpg'
    ),
    /* 会员TOKEN类型 */
    'MEMBER_TOKEN_TYPE' => array(
        'ACTIVE_ACCOUNT' => 1, // 邮箱激活账户
        'RESET_PASSWORD' => 2, // 忘记密码/重置密码
    ),
    /* 第三方登录信息Session键名 */
    'CONNECT_SESSION_KEY' => 'ConnectInfo',
    /* 用户默认有效登录时间 */
    'USER_DEFAULT_EFFECTIVE_TIME' => '864000', //默认10天
    /* 推荐位标识 */
    'POSITION_FLAG' => array(
        'RECOMMENDED_APPLICATION' => 'RECOMMENDED_APPLICATION', //推荐应用
        'SPECIAL_RECOMMENDED' => 'SPECIAL_RECOMMENDED', //特别推荐
        'TOPIC_FOR_APP' => 'TOPIC_FOR_APP', //移动端用专题
        'ONE_DAY_ONE_APPLICATION' => 'ONE_DAY_ONE_APPLICATION', //每日一荐
        'TOP_SLIDER' => 'TOP_SLIDER', //首页顶部幻灯片
        'TOPIC_MUST_INSTALL' => 'TOPIC_MUST_INSTALL', //专题-装机必备
    ),
    /* 默认模型名称 */
    'DEFAULT_MODEL_NAME' => 'Content',
    /* 关联模型副表字段名 */
    'SIDE_TABLE_DATA_FIELD' => '_side_table_data_',
    /* 分表设置 */
    'SIDE_TABLE_SUFFIX' => '_data', //分表后缀
    /* 模块安装 */
    'DEFAULT_DB_PREFIX' => 'bpi_', //默认数据库前缀
    /* 后台菜单设置 */
    'ADMIN_MENU_DEFAULT_APP' => 'Admin', //后台菜单默认app
    'ADMIN_MENU_DEFAULT_MODULE' => 'Index', //后台菜单默认module
    
    /* 编辑器内容中保存的附件标识 */
    'EDITOR_CONTENT_ATTACHMENT_FLAG' => '__attachment_id__',
);
?>
