<?php

// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2012 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------

defined('THINK_PATH') or exit();

/**
 * 系统行为扩展：定位模板文件
 * @category   Think
 * @package  Think
 * @subpackage  Behavior
 * @author   liu21st <liu21st@gmail.com>
 */
class LocationTemplateBehavior extends Behavior {

    // 行为扩展的执行入口必须是run
    public function run(&$templateFile) {
        // 自动定位模板文件
        if (!file_exists_case($templateFile))
            $templateFile = $this->parseTemplateFile($templateFile);
    }

    /**
     * 自动定位模板文件
     * @access private
     * @param string $templateFile 文件名
     * @return string
     */
    private function parseTemplateFile($templateFile) {
        if ('' == $templateFile) {
            // 如果模板文件名为空 按照默认规则定位
            $templateFile = C('TEMPLATE_NAME');
        } elseif (false === strpos($templateFile, C('TMPL_TEMPLATE_SUFFIX'))) {
            // 解析规则为 分组@模板主题:模块:操作
            if (strpos($templateFile, '@')) {
                list($group, $templateFile) = explode('@', $templateFile);
                if (1 == C('APP_GROUP_MODE')) {
                    $basePath = dirname(BASE_LIB_PATH) . '/';
                } else {
                    $basePath = TMPL_PATH;
                }
                $basePath .= $group . '/' . basename(TMPL_PATH) . '/' . (THEME_NAME ? THEME_NAME . '/' : '');
            } else {
                $basePath = THEME_PATH;
            }
            $path = explode(':', $templateFile);
            $action = array_pop($path);
            $module = !empty($path) ? array_pop($path) : MODULE_NAME;
            if (!empty($path)) {// 设置模板主题
                $basePath = dirname($basePath) . '/' . array_pop($path) . '/';
            }
            $templateFile = $basePath . $module . C('TMPL_FILE_DEPR') . $action . C('TMPL_TEMPLATE_SUFFIX');
        }
        if (!file_exists_case($templateFile))
            throw_exception(L('_TEMPLATE_NOT_EXIST_') . '[' . $templateFile . ']');
        return $templateFile;
    }

}