<?php

/**
 * apk文件更新处理方法
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-1
 * @updateTime 2013-7-1
 */
function apk_file($fieldInfo, $value) {
    $value = unserialize($value);
    $attachmentIds = array();
    foreach ($value as $fileInfo) {
        $attachmentIds[] = intval($fileInfo['attachment_id']);
    }

    // 更新到附件列表
    $newAttachmentIds = BService('Attachment')->apiUpdate($fieldInfo['setting']['access_type'], $this->targetId, $attachmentIds, $fieldInfo['setting']['attachment_flag']);
    // 判断成功了的附件列表与当前的附件列表是否有差异
    if (array_diff($attachmentIds, $newAttachmentIds)) {
        // 筛选update成功的，重新插入到文章列表
        $attachmentsInfo = array();
        foreach ($newAttachmentIds as $attachmentId) {
            $attachmentsInfo[$attachmentId] = $value[$attachmentId];
        }

        // 返回数组让ContentService进行更新操作
        return serialize($attachmentsInfo);
    } else {
        return serialize($value);
    }
}

?>
