<?php

/**
 * 选项字段表单显示处理类
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-16
 * @updateTime 2013-5-16
 */

/**
 * 选项字段表单显示处理
 * @param type $fieldInfo   字段相关信息
 * @param type $value       当前选中值
 * @return type             表单HTML
 */
function box($fieldInfo, $value) {
    // 分割选项
    $options = array();
    foreach (explode("\n", $fieldInfo['setting']['options']) as $option) {
        $optionExplode = explode('|', $option);
        $options[trim($optionExplode[1])] = $optionExplode[0];
    }

    // 分割值
    $selecteds = array();
    foreach (explode(',', $value) as $selected) {
        if (array_key_exists($selected, $options)) {
            $selecteds[] = $selected;
        }
    }

    $attribute = '';
    if ($fieldInfo['setting']['box_type'] == 'select' || $fieldInfo['setting']['box_type'] == 'multiple') {
        if ($fieldInfo['setting']['box_type'] == 'multiple' || $fieldInfo['setting']['box_rows']) {
            $attribute .= 'style="height:auto;"';
            if ($fieldInfo['setting']['box_rows']) {//指定显示行数
                $attribute .= ' size=' . intval($fieldInfo['setting']['box_rows']);
            }
            if ($fieldInfo['setting']['box_type'] == 'multiple') {
                $attribute .= ' multiple="multiple" ';
            }
        }
    }

    $assignVal = array(
        'fieldInfo' => $fieldInfo,
        'boxType' => $fieldInfo['setting']['box_type'],
        'options' => $options,
        'selecteds' => $selecteds,
        'attribute' => $attribute
    );
    return $this->fetch($fieldInfo['field_type'], $assignVal);
}

?>