<?php

/**
 * 选项输出处理
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-16
 * @updateTime 2013-5-16
 */
function box($fieldInfo, $value) {
    $options = array();
    //获取key value分开的数组
    foreach (explode("\n", $fieldInfo['setting']['options']) as $option) {
        $optionExplode = explode('|', $option);
        $options[trim($optionExplode[1])] = $optionExplode[0];
    }

    switch ($fieldInfo['setting']['box_type']) {
        case 'checkbox':
        case 'multiple':
            // 分割值
            $selectList = array();
            foreach (explode(',', $value) as $key) {
                if (array_key_exists($key, $options)) {
                    $selectList[$key] = $options[$key];
                }
            }
            $value = $selectList;
            break;
        default:
            $value = $options[$value];

            break;
    }

    return $value;
}

?>