<?php

/**
 * 字段内容处理基类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-9
 * @updateTime 2013-5-9
 */
class ContentBase {

    protected $targetId, $modelId, $categoryId, $isInAdmin, $classType;
    protected $modelCache, $fieldList, $data;
    protected $error;

    /**
     * 构造函数
     * @param type $modelId
     * @param type $targetId
     * @param type $actionName
     * @return boolean
     */
    public function __construct($modelId) {
        $this->modelCache = D('Model')->getModelByType(NULL, 1);
        $this->isInAdmin = defined('IN_ADMIN') && IN_ADMIN;

        $this->modelId = intval($modelId);
        if (array_key_exists($this->modelId, $this->modelCache)) {
            $fieldList = F('ModelField' . $this->modelId);
            $parentFieldList = F('ModelField' . $this->modelCache[$this->modelId]['pid']);

            if (!is_array($fieldList)) {
                $fieldList = array();
            }

            $this->fieldList = is_array($parentFieldList) ? array_merge($parentFieldList, $fieldList) : $fieldList;
        } else {
            throw_exception('modelId ' . $this->modelId . ' does not exist');
        }
    }

    /**
     * 设置错误提示
     * @param type $message
     * @param type $jumpUrl
     * @param type $isAjax
     */
    public function setError($message) {
        $this->error = $message;
    }

    /**
     * 获取错误提示
     * @return type
     */
    public function getError() {
        return $this->error;
    }

//    /**
//     * 调用指定函数
//     * @param type $function
//     * @param type $param
//     * @param type $setting
//     * @param type $field
//     * @param type $value
//     */
//    private function _callFunction($function, $param, $setting, $field, $value, $type) {
//        $checkFuntionType = false;
//        switch ($type) {
//            case 'input':
//                //入库前，前后
//                $targetId = 0;
//                $checkFuntionType = intval($setting['back_function_type']) == C('MODEL_FIELD_FUNCTION_RUN_TIME.BEFORE') || (intval($setting['back_function_type']) == C('MODEL_FIELD_FUNCTION_RUN_TIME.ALL'));
//                break;
//            case 'update':
//                //入库后，前后
//                $targetId = $this->targetId;
//                $checkFuntionType = intval($setting['back_function_type']) == C('MODEL_FIELD_FUNCTION_RUN_TIME.AFTER') || (intval($setting['back_function_type']) == C('MODEL_FIELD_FUNCTION_RUN_TIME.ALL'));
//                break;
//            default :
//                return false;
//                break;
//        }
//        //检查方法是否存在
//        if (function_exists($function)) {
//            //判断是否入库执行类型
//            if ($checkFuntionType) {
//                //调用自定义函数，参数传入：模型id，栏目ID，信息ID，字段内容，字段名，操作类型，附加参数
//                // 例子 demo($modelId, $categoryId, $id, $value, $field, $action, $param){}
//                return @$value = call_user_func($function, $this->modelId, $this->categoryId, $targetId, $value, $field, $this->actionName, $param);
//            }
//        }
//        return FALSE;
//    }
//    /**
//     * 调用字段扩展函数处理
//     * @param type $setting
//     * @param type $field
//     */
//    protected function dealFieldFunction($setting, $field, $value) {
//        if ($setting['back_function'] || $setting['front_function']) {
//            load('@.treatFunction');
//            $backFunction = explode('###', $this->isInAdmin ? $setting['back_function'] : $setting['front_function']);
//            //准备调用的参数
//            $handleFunction = $backFunction[0];
//            $handleParam = $backFunction[1];
//            //检查前后台
//            if ($this->isInAdmin) {//后台
//                $value = self::_callFunction($handleFunction, $handleParam, $setting, $field, $value, $this->classType);
//            } else {//前台
//                //前台投稿处理自定义函数
//                //TODO:判断当前用户组是否拥有使用字段处理函数的权限
//                if (true) {
//                    $value = self::_callFunction($handleFunction, $handleParam, $setting, $field, $value, $this->classType);
//                }
//            }
//        }
//        return $value;
//    }

    /**
     * 根据内容设置成员变量
     * @param type $data        文章内容数据
     */
    public function data($data) {
        // $data验证
        if (empty($data)) {
            if ($this->classType === 'form') {
                return;
            } else {
                throw_exception('$data empty');
            }
        }
        $this->data = $data;

        // 模型ID验证
        if (isset($data['model_id'])) {
            if ($this->modelId !== intval($data['model_id'])) {
                throw_exception('Init $this->modelId ' . $this->modelId . ' is different from $data[\'model_id\'] ' . intval($data['model_id']));
            }
        }
        $data['model_id'] = $this->modelId;

        // 操作ID验证
        $this->targetId = intval($data['id']);
        if (!in_array($this->classType, array('input', 'form'), TRUE) && empty($this->targetId)) {
            throw_exception('targetId illegal');
        }

        //抽取栏目
        if (isset($data['category_id']) && $data['category_id']) {
            $this->categoryId = intval($data['category_id']);
        }
        $this->data = $data;
    }

    /**
     * 简易处理字段，适用于主体功能只有调用同名处理方法
     * @param type $data
     */
    protected function simpleHandleFuntion($data = array()) {
        $this->data($data);

        $info = array();
        switch ($this->classType) {
            //TODO:处理常量
            case 'delete':
                $functionType = 'delete';
                break;
            case 'output':
                $functionType = 'output';
                break;
            case 'update':
                $functionType = 'update';
                break;
            default:
                break;
        }
        foreach ($this->fieldList as $fieldName => $fieldInfo) {
            // 为空则不用过滤
            if (!isset($this->data[$fieldName])) {
                continue;
            }

            // 源数据
            $value = $this->data[$fieldName];

            // 数据处理
            $fieldInfo['setting'] = unserialize($fieldInfo['setting']);
            $handleFunctions = trim($fieldInfo['setting'][$functionType . '_function'], '| ');
            if (empty($handleFunctions)) {
                $handleFunctions = array($fieldInfo['field_type']);
            } else {
                $handleFunctions = explode('|', $handleFunctions);
            }

            foreach ($handleFunctions as $function) {
                //检测对应字段方法是否存在，存在则执行此方法，并传入字段名和字段值
                if (method_exists($this, $function)) {
                    $value = $this->$function($fieldInfo, $value);
                }
            }

            // 返回数据TODO : 是否需要优化回传参数的方式
            if ('update' === $functionType) {
                if ($value !== $this->data[$fieldName]) {
                    // 返回到ContentService进行数据更新,分开系统字段和模型字段
                    if ($fieldInfo['is_system']) {
                        $info['system'][$fieldName] = (string) $value;
                    } else {
                        $info['model'][$fieldName] = (string) $value;
                    }
                }
            } else {
                $info[$fieldName] = $value;
            }
        }
        return $info;
    }

}

?>
