<?php

import('contentBase', C('FIELD_DIR_PATH'));

/**
 * 字段显示输入表单类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-12
 * @updateTime 2013-4-12
 */
class ContentForm extends ContentBase {

    protected $formValidateRuleList; //表单验证规则list
    protected $formValidateMessageList; //表单验证消息list

    /**
     * 构造函数
     * @param type $data 表格数据
     */

    function __construct($modelId) {
        $this->classType = 'form';
        parent::__construct($modelId);
    }

    /**
     * 获取模型字段信息
     * @param type $data
     */
    function get($data = array()) {
        $this->data($data);
        $info = array();

        foreach ($this->fieldList as $field => $fieldInfo) {
            //判断，如果是内部字段则跳过
            if ($fieldInfo['is_private'] || !($this->isInAdmin || $fieldInfo['is_show_in_post'])) {
                continue;
            }

            $fieldFunction = $fieldInfo['field_type'];
            $fieldInfo['setting'] = unserialize($fieldInfo['setting']);
            // 对样式属性等进行转义
            foreach (array('class', 'style', 'property') as $key) {
                $fieldInfo[$key] = bpiHtmlspecialcharsDecode($fieldInfo[$key]);
            }
            // 找不到信息进行读取默认值
            if (isset($this->data[$field])) {
                $value = Input::getVar($this->data[$field]);
            } else {
                $value = $fieldInfo['setting']['default_value'];
            }

            if (!method_exists($this, $fieldFunction)) {
                continue;
            }

            //生成的表格组件
            $formModule = $this->$fieldFunction($fieldInfo, $value);
            if ($formModule !== false) {
                //是否有星号提醒标记
                $isNotice = $fieldInfo['min_length'] || $fieldInfo['pattern'] ? 1 : 0;
                //是否基本字段
                $type = $fieldInfo['is_base'] ? 'base' : 'extend';
                $info[$type][$field] = array(
                    'name' => $fieldInfo['name'],
                    'tips' => $fieldInfo['tips'],
                    'form_module' => $formModule,
                    'is_notice' => $isNotice,
                    'is_omnipotent' => $fieldInfo['is_omnipotent'],
                    'field_type' => $fieldInfo['field_type'],
                    'sort' => $fieldInfo['sort'],
                );
            }

            //错误提示
            $errorTips = $fieldInfo['error_tips'];
            if ($fieldInfo['min_length']) {
                //验证规则
                $this->formValidateRuleList['info[' . $field . ']'] = array('required' => true);
                //验证不通过提示
                $this->formValidateMessageList['info[' . $field . ']'] = array('required' => $errorTips ? $errorTips : $fieldInfo['name'] . '不能为空');
            }

            //生成对应js验证规则
            //TODO:意义不明
            $this->formValidateRuleList = $this->getValidateJson($this->formValidateRuleList);
            $this->formValidateMessageList = $this->getValidateJson($this->formValidateMessageList, true);
        }
        //排序
        $info['base'] = sortArrayByKey($info['base']);
        $info['extend'] = sortArrayByKey($info['extend']);
        return $info;
    }

    /**
     * 转换便当验证数据为json格式
     * @param type $ruleList
     * @param type $isAddQuotation
     * @return string
     */
    //TODO:未检测
    protected function getValidateJson($ruleList, $isAddQuotation = false) {
        foreach ($ruleList as $formName => $value) {
            $value = array();
            if (is_array($value)) {
                foreach ($value as $k => $v) {
                    //消息需要加引号，否则js报错
                    if ($isAddQuotation) {
                        $value[] = "$k:'$v'";
                    } else {
                        $value[] = "$k:$v";
                    }
                }
            }
            $value = '{' . implode(',', $value) . '}';
            $ruleList[] = "$formName:$value";
        }
        $ruleList = '{' . implode(',', $ruleList) . '}';
        return $ruleList;
    }

    /**
     * 自动解析模版
     * @param type $templateFile    模版路径
     * @param type $assignVal       注册变量
     * @return type                 返回已经解析的模版内容
     */
    protected function fetch($fieldName, $assignVal = array()) {
        // 处理路径
//        $templateFile = trim(str_replace(array('/', '\\'), DS, $templateFile), DS);
        $templateFile = C('FIELD_DIR_PATH') . $fieldName . DS . 'content_form.html';

        // 补全文件路径
//        if (!is_file($templateFile)) {
//            $templateFile = C('FIELD_DIR_PATH') . $templateFile;
//        }
        // 解析模版
        $view = new View;
        $view->assign($assignVal);
        return $view->fetch($templateFile);
    }

}

?>
