<?php

import('contentBase', C('FIELD_DIR_PATH'));

/**
 * 字段输入处理类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-25
 * @updateTime 2013-4-25
 */
class ContentInput extends ContentBase {

    /**
     * 构造函数
     * @param type $modelId 模型id
     */
    function __construct($modelId) {
        $this->classType = 'input';
        parent::__construct($modelId);
    }

    /**
     * 数据入库之前处理
     * @param type $data 处理数据
     * @param type $isImport 是否直接入库处理，跳过提示报错
     */
    public function get($data, $isImport = 0) {
        $this->data($data);

        $info = array(
            'system' => array(),
            'model' => array()
        );
        foreach ($this->data as $fieldName => $value) {
            $fieldInfo = $this->fieldList[$fieldName];
            if (empty($fieldInfo)) {
                continue;
            }
            //判断，如果是内部字段则跳过
            if ($fieldInfo['is_private'] || !($this->isInAdmin || $fieldInfo['is_show_in_post'])) {
                continue;
            }
            //字段别名
            $name = $fieldInfo['name'];
            //最小值
            $minLength = $fieldInfo['min_length'];
            //最大值
            $maxLength = $fieldInfo['max_length'];
            //校验模式
            $pattern = $fieldInfo['pattern'];
            //数据校验未通过的提示信息
            $errorTips = $fieldInfo['error_tips'];
            //配置
            $fieldInfo['setting'] = unserialize($fieldInfo['setting']);

            //默认提示
            if (empty($errorTips)) {
                $errorTips = $name . ' 不符合要求';
            }

            //数据长度
            $length = empty($value) ? 0 : strlen($value);
            //长度验证
            if ($minLength && $length < $minLength) {
                if (!$isImport) {
                    $this->setError($name . ' 不得少于 ' . $minLength . ' 个字符');
                }
                return false;
            }
            if ($maxLength && $length > $maxLength) {
                if (!$isImport) {
                    $this->setError($name . ' 不得多于 ' . $maxLength . ' 个字符');
                    return false;
                }
                $value = cutString($value, 0, $maxLength);
            }

            //数据校验
            if ($pattern && $length && !preg_match($pattern, $value) && !$isImport) {
                $this->setError($errorTips);
                return false;
            }
//
//            //值唯一检测
//            if ($fieldInfo['is_unique'] && ($this->contentModel->where(array($fieldName => $value))->count($fieldName) > 0) && ($this->actionName != 'edit')) {
//                $this->setError($name . '该值必须唯一');
//                return false;
//            }
            // 函数处理
            $inputFunctions = trim($fieldInfo['setting']['input_function'], '| ');
            if (empty($inputFunctions)) {
                $inputFunctions = array($fieldInfo['field_type']);
            } else {
                $inputFunctions = explode('|', $inputFunctions);
            }

            foreach ($inputFunctions as $inputFunction) {
                //检测对应字段方法是否存在，存在则执行此方法，并传入字段名和字段值
                if (method_exists($this, $inputFunction)) {
                    //当没有返回时，或者为 null 时，等于空字符串，null有时会出现mysql 语法错误。
                    $value = (string) $this->$inputFunction($fieldInfo, $value);
                }
            }

            //调用函数处理，TODO: 输入输出函数整改，暂时先注释没用到的功能
//            $value = self::dealFieldFunction($fieldInfo['setting'], $fieldName, $value);
            //分开系统字段和模型字段
            if ($fieldInfo['is_system']) {
                $info['system'][$fieldName] = $value;
            } else {
                $info['model'][$fieldName] = $value;
            }
            //TODO:这段是否应该存在这里，style字段已被删除
            //颜色选择为隐藏域
            // $info['system']['style'] = $_POST['style_color'] ? strip_tags($_POST['style_color']) : '';
            //样式
//            if ($_POST['style_font_weight']) {
//                $info['system']['style'].=';' . strip_tags($_POST['style_font_weight']);
//            }
        }

        return $info;
    }

}

?>
