<?php

/**
 * 日期表单生成
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-17
 * @updateTime 2013-5-17
 */
function datetime($fieldInfo, $value) {
    $setting = $fieldInfo['setting'];
    //时间格式
    $fieldType = $setting['field_type'];

    $format = $setting['format'];
    $pickerFormat = array('date' => 'yy-mm-dd', 'time' => 'HH:mm:ss');
    if ('date' === $fieldType) {
        $format = 'Y-m-d';
    } else if ('datetime_a' === $fieldType) {
        $format = 'Y-m-d Ah:i:s';
    }

    switch ($format) {
        case 'Y-m-d':
            $pickerFormat['time'] = '';
            break;

        case 'Y-m-d Ah:i:s':
            $format = 'Y-m-d h:i:s';
            $pickerFormat['time'] = 'h:mm:ss';
            break;

        case 'Y-m-d H:i':
            $pickerFormat['time'] = 'HH:mm';
            break;
        
        case 'm-d':
            $pickerFormat['date'] = 'mm-dd';
            $pickerFormat['time'] = '';
            break;

        default:
            break;
    }

    // 对时间进行特殊处理
    if (isset($this->data[$fieldInfo['field']])) {
        $value = Input::getVar($this->data[$fieldInfo['field']]);
        if ($fieldType !== 'int') {
            $value = strtotime($value);
        }
    } else if ($fieldInfo['setting']['default_value']) {
        $value = time();
    } else {
        $value = '';
    }

    // 显示时间
    is_numeric($value) && $value = date($format, $value);

    $assignVal = array(
        'fieldInfo' => $fieldInfo,
        'value' => $value,
        'pickerFormat' => $pickerFormat
    );
    return $this->fetch($fieldInfo['field_type'], $assignVal);
}

?>