<?php

/**
 * editor更新处理方法
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-1
 * @updateTime 2013-7-1
 */
function editor($fieldInfo, $value) {
    $content = BService('Attachment')->downloadFromContent($value);
    $setting = unserialize($fieldInfo['setting']);
    $attachmentIdFlag = C('EDITOR_CONTENT_ATTACHMENT_FLAG'); //附件id标识
    //匹配附件ids
    $attachmentIds = array();
    if (preg_match_all("/$attachmentIdFlag=\"(\d*)\"/", $content, $matches)) {
        $attachmentIds = $matches[1];
    }

    $attachmentService = BService('Attachment');
    if ($attachmentIds) {
        foreach ($attachmentIds as $key => $attachmentId) {
            //检测附件是否存在
            $attachment = $attachmentService->getAttachmentInfo($attachmentId);
            if (empty($attachment)) {
                unset($attachmentIds[$key]);
                //内容移除附件标识
                $content = str_replace($attachmentIdFlag . '="' . $attachmentId . '"', '', $content);
            }
        }
    }
    //更新附件
    $attachmentService->apiUpdate($setting['access_type'], $this->targetId, $attachmentIds, C('ATTACHMENT_FLAG.EDITOR_IMAGE'));

    return $content;
}

?>