<?php

/**
 * 字段类型配置文件
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-11
 * @updateTime 2013-4-11
 */
class FieldConfig {

    //TODO:补充可用字段列表
    protected static $fieldTypeList = array(
        'text' => array(
            'name' => '单行文本',
            'allowShow' => true,
            'allowAddStyle' => true,
        ),
        'category_id' => array(
            'name' => '栏目id',
//            'allowDelete' => false, //不能删除
//            'allowForbid' => false, //不能禁用
//            'isUnique' => true, //唯一
        ),
        'textarea' => array(
            'name' => '文本框',
            'allowShow' => true,
            'allowAddStyle' => true//允许增加样式
        ),
        'image' => array(
            'name' => '图片',
            'allowShow' => true,
        ),
        'editor' => array(
            'name' => '编辑器',
            'allowShow' => true,
        ),
        'title' => array(
            'name' => '标题',
//            'allowForbid' => false,
//            'allowDelete' => false, //不能删除
        ),
        'box' => array(
            'name' => '选项',
            'allowShow' => true,
            'allowAddStyle' => true,
        ),
//        'multi_image' => array(
//            'name' => '多图片'
//        ),
        'number' => array(
            'name' => '数字',
            'allowShow' => true,
            'allowAddStyle' => true
        ),
        'datetime' => array(
            'name' => '日期和时间',
            'allowShow' => true,
        ),
//        'keyword' => array(
//            'name' => '关键字',
//            'allowDelete' => false,
//            'allowAddStyle' => true
//        ),
//        'author' => array(
//            'name' => '作者',
//            'isUnique' => true
//        ),
//        'copy_from' => array(
//            'name' => '来源',
//            'isUnique' => true
//        ),
        'is_link' => array(
            'name' => '转向链接',
            'allowShow' => true,
//            'isUnique' => true
        ),
        'template' => array(
            'name' => '模版',
//            'allowDelete' => false,
//            'allowForbid' => false
        ),
//        'page' => array(
//            'name' => '分页选择',
//            'isUnique' => true
//        ),
//        'type_id' => array(
//            'name' => '类别',
//            'allowShow' => false,
//            'allowAddStyle' => true
//        ),
        'position' => array(
            'name' => '推荐位',
//            'allowDelete' => false
        ),
//        'link_field' => array(
//            'name' => '关联字段'
//        ),
        'multi_file' => array(
            'name' => '多文件上传',
            'allowShow' => true,
        ),
        'apk_file' => array(
            'name' => 'APK程序字段',
            'allowShow' => true,
        ),
//        'map' => array(
//            'name' => '地图字段'
//        ),
        'omnipotent' => array(
            'name' => '万能字段',
            'allowShow' => true,
        ),
    );

    /**
     * 返回可用字段类型列表
     * @param type $onlyShow    是否只返回允许显示的字段列表
     * @return type
     */
    public static function getFieldTypeList($onlyShow = FALSE) {
        if ($onlyShow) {
            $fieldTypeList = self::$fieldTypeList;
            foreach ($fieldTypeList as $fieldName => $value) {
                if (!$value['allowShow']) {
                    unset($fieldTypeList[$fieldName]);
                }
            }
            return $fieldTypeList;
        } else {
            return self::$fieldTypeList;
        }
    }

    /**
     * 返回指定字段类型
     * @param type $fieldName
     * @return type
     */
    public static function getFieldType($fieldName) {
        return self::$fieldTypeList[$fieldName];
    }

//    /**
//     * 特殊字段集合
//     * @var type 
//     */
//    protected static $specialFieldArray = array(
//        //不允许删除的字段，这些字段讲不会在字段添加处显示
//        'notAllowFields' => array('category_id'),
//    );
//    /**
//     * 返回特殊字段集合
//     * @return type
//     */
//    public static function getSpecialFieldArray() {
//        return self::$specialFieldArray;
//    }
////不允许删除的字段，这些字段讲不会在字段添加处显示
//$not_allow_fields = array('catid','typeid','title','keyword','template','username','posid');
////允许添加但必须唯一的字段
//$unique_fields = array('pages','readpoint','author','copyfrom','islink');
////禁止被禁用的字段列表
//$forbid_fields = array('catid','title','updatetime','inputtime','url','listorder','status','template','username','allow_comment');
////禁止被删除的字段列表
//$forbid_delete = array('catid','typeid','title','thumb','keywords','updatetime','inputtime','posids','url','listorder','status','template','username','allow_comment');
////可以追加 JS和CSS 的字段
//$att_css_js = array('text','textarea','box','number','keyword','typeid');
}

?>
