<?php

/**
 * 多文件上传表单显示
 * @author     lyz
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-20
 * @updateTime 2013-5-20
 */
function multi_file($fieldInfo, $value) {
    $filesInfo = array();
    $attachmentIds = array();
    foreach (unserialize($value) as $fileInfo) {
        $filesInfo[$fileInfo['attachment_id']] = $fileInfo;
        $attachmentIds[] = $fileInfo['attachment_id'];
    }

    if (!empty($filesInfo)) {
        // 查询附件信息
        $attachmentList = BService('Attachment')->getAttachmentInfo($attachmentIds);
        // 处理一下数据
        if (is_array($attachmentList)) {
            $value = array();
            foreach ($attachmentList as $attachment) {
                $attachmentId = $attachment['attachment_id'];
                $value[$attachmentId] = array(
                    'attachment_id' => $attachmentId,
                    'url' => $attachment['file_url'],
                    'ext' => $attachment['file_ext'],
                    'name' => $attachment['file_name'],
                    'group_id' => $filesInfo[$attachmentId]['group_id'],
                    'point' => $filesInfo[$attachmentId]['point'],
                );
            }
        }
    }

    $config = BaseAction::getVar('config');
    $assignVal = array(
        'value' => $value,
        'isAdmin' => $this->isInAdmin,
        'field' => $fieldInfo['field'],
        'setting' => $fieldInfo['setting'],
        'memberGroup' => FData('MemberGroup'),
        'maxUploadSize' => $this->isInAdmin ? $config['upload_admin_max_size'] : $config['upload_max_size']
    );
    return $this->fetch($fieldInfo['field_type'], $assignVal);
}
?>

