<?php

/**
 * 多文件输入保存处理方法
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-6-25
 * @updateTime 2013-6-25
 */
function multi_file($fieldInfo, $value) {
    $filesInfo = array();
    foreach ($value['attachment_id'] as $key => $attachmentId) {
        // 过滤重复
        if (isset($filesInfo[$attachmentId])) {
            continue;
        }

        if ($this->isInAdmin) {
            $filesInfo[$attachmentId] = array(
                'attachment_id' => $attachmentId,
                'group_id' => $value['group_id'][$key],
                'point' => $value['point'][$key]
            );
        } else {
            $filesInfo[$attachmentId] = array(
                'attachment_id' => $attachmentId
            );
        }
    }

    return serialize($filesInfo);
}

?>
