<?php

/**
 * 多文件表单显示处理方法
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-6-25
 * @updateTime 2013-6-25
 */
function multi_file($fieldInfo, $value) {
    $filesInfo = array();
    $attachmentIds = array();

    foreach (unserialize($value) as $fileInfo) {
        $attachmentId = intval($fileInfo['attachment_id']);
        if (!isset($filesInfo[$attachmentId])) {
            $filesInfo[$attachmentId] = $fileInfo;
            $attachmentIds[] = $attachmentId;
        }
    }

    if (!empty($filesInfo)) {
        // 查询附件信息
        $attachmentList = BService('Attachment')->getAttachmentInfo($attachmentIds);
        // 处理一下数据
        if (is_array($attachmentList)) {
            $attachmentsInfo = array();
            foreach ($attachmentList as $attachment) {
                $attachmentId = $attachment['attachment_id'];
                $attachmentsInfo[$attachmentId] = array(
                    'attachment_id' => $attachmentId,
                    'url' => $attachment['file_url'],
                    'ext' => $attachment['file_ext'],
                    'name' => $attachment['file_name'],
                    'group_id' => $filesInfo[$attachmentId]['group_id'],
                    'point' => $filesInfo[$attachmentId]['point'],
                );
            }
            return $attachmentsInfo;
        }
    }

    return array();
}

?>
