<?php

/**
 * 错误代码工具类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-29
 * @updateTime 2013-7-29
 */
class ErrorCode {

    private $projectCode;
    private $fileCode;
    private $methodCode;
    private $errorCode;
    private $errorTypeFlag;

    function __construct($errorTypeFlag = NULL, $projectCode = NULL, $fileCode = NULL, $methodCode = NULL, $errorCode = NULL) {
        $this->errorTypeFlag = intval($errorTypeFlag);
        $this->projectCode = intval($projectCode);
        $this->fileCode = $this->_getFormatNum($fileCode, 2);
        $this->methodCode = $this->_getFormatNum($methodCode, 2);
        $this->errorCode = $this->_getFormatNum($errorCode, 2);
    }

    public function setProjectCode($projectCode) {
        $this->projectCode = $this->_getFormatNum($projectCode, 2);
    }

    public function setFileCode($fileCode) {
        $this->fileCode = $this->_getFormatNum($fileCode, 2);
    }

    public function setMethodCode($methodCode) {
        $this->methodCode = $this->_getFormatNum($methodCode, 2);
    }

    /**
     * 获得格式化的服务错误代码
     * @param type $errorCode
     * @return type 
     */
    public function getServiceError($errorCode) {
        $errorCode = $this->_getFormatNum($errorCode, 2);
        //整改，兼容服务级公用错误代码
        $errorCodeString = $this->errorTypeFlag . $this->projectCode . sprintf('%0' . 6 . 'd', $this->fileCode . $this->methodCode . $errorCode);
        return intval($errorCodeString);
    }

    /**
     * 格式化成系统错误代码
     * @param type $code
     * @return type 
     */
    public function getSystemError($errorCode) {
        $errorCode = self::_getFormatNum($errorCode, 2);
        $errorCodeString = $this->errorTypeFlag . sprintf('%0' . 7 . 'd', $errorCode);
        return intval($errorCodeString);
    }

    /**
     * 获得格式化后的数字
     * @param type $num
     * @param type $length
     * @return type 
     */
    private function _getFormatNum($num, $length) {
        return sprintf('%0' . $length . 'd', $num);
    }

}

?>
