<?php

/**
 * 服务级状态码
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-30
 * @updateTime 2013-7-30
 */
class ServiceRetCode {
    /**
     * (手机客户端）获取用户信息失败
     */

    const RET_USER_INFO_ERROR = 4;
    /**
     * 登录态失效
     */
    const RET_LOGINSTATE_INVALID = 9;
    /**
     * 登录态验证失败
     */
    const RET_LOGINSTATE_FAIL = 10;
    /**
     * 查询订单信息失败
     */
    const RET_ORDER_INFO_ERROR = 300;
    /**
     * 查询卡片信息失败
     */
    const RET_CARD_INFO_ERROR = 400;
    /**
     * 获取卡片列表信息失败
     */
    const RET_CARD_LIST_ERROR = 405;

    /**
     * 查询卡片成品信息失败
     */
    const RET_CARD_FUSION_INFO_ERROR = 410;

    /**
     * 查询卡片成品列表信息失败
     */
    const RET_CARD_FUSION_LIST_ERROR = 415;
    /**
     * 查询卡片主题列表信息失败
     */
    const RET_CARD_THEME_LIST_ERROR = 420;
    /**
     * 查询用户地址列表信息失败
     */
    const RET_USER_ADDRESS_LIST_ERROR = 500;
    /**
     * 查询活动信息失败
     */
    const RET_ACTIVITY_INFO_ERROR = 910;

    /**
     * 状态码对应状态信息列表
     * @var type 
     */
    static public $messageArray = array(
        self::RET_USER_INFO_ERROR => '获取用户信息失败', //4
        self::RET_LOGINSTATE_FAIL => '登录验证失败', //10
        self::RET_ORDER_INFO_ERROR => '查询订单信息失败', //300
        self::RET_CARD_INFO_ERROR => '查询卡片信息失败', //400
        self::RET_CARD_LIST_ERROR => '查询卡片列表失败', //405
        self::RET_CARD_FUSION_INFO_ERROR => '查询卡片成品信息失败', //410
        self::RET_CARD_FUSION_LIST_ERROR => '查询卡片成品列表失败', //415
        self::RET_CARD_THEME_LIST_ERROR => '查询卡片主题列表信息失败', //420
        self::RET_USER_ADDRESS_LIST_ERROR => '查询用户地址列表失败', //500
        self::RET_ACTIVITY_INFO_ERROR => '查询活动信息失败', //910
    );

    /**
     * 根据状态码返回状态信息
     * @param type $code
     * @return type
     */
    static public function getMessage($code) {
        return isset(self::$messageArray[$code]) ? self::$messageArray[$code] : '';
    }

}

?>
