<?php

/**
 * 拼音类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-22
 * @updateTime 2013-11-22
 */
class Pinyin {

    /**
     * utf-8转拼音
     * @param type $string
     * @return type
     */
    static function utf8_to_pinyin($string) {
        return self::gbk_to_pinyin(iconv('utf-8', 'gbk//IGNORE', $string));
    }

    /**
     * gbk转拼音
     * @param $string
     */
    static function gbk_to_pinyin($string) {
        $l = strlen($string);
        $i = 0;
        $pyarr = array();
        $py = array();
        $filename = dirname(__FILE__) . '\gb-pinyin.table';
        $fp = fopen($filename, 'r');
        while (!feof($fp)) {
            $p = explode('-', fgets($fp, 32));
            $pyarr[intval($p[1])] = trim($p[0]);
        }
        fclose($fp);
        ksort($pyarr);
        while ($i < $l) {
            $tmp = ord($string[$i]);
            if ($tmp >= 128) {
                $asc = abs($tmp * 256 + ord($string[$i + 1]) - 65536);
                $i = $i + 1;
            }
            else
                $asc = $tmp;
            $py[] = self::asc_to_pinyin($asc, $pyarr);
            $i++;
        }
        return $py;
    }

    /**
     * Ascii转拼音
     * @param $asc
     * @param $pyarr
     */
    static function asc_to_pinyin($asc, &$pyarr) {
        if ($asc < 128)
            return chr($asc);
        elseif (isset($pyarr[$asc]))
            return $pyarr[$asc];
        else {
            foreach ($pyarr as $id => $p) {
                if ($id >= $asc)
                    return $p;
            }
        }
    }

}

?>
