<?php

/**
 * 自定义模板便签库类
 * @author     bant
 * @copyright  (C) 2011-2014 EXCMS
 * @license    http://www.zyxfeng.com/license/
 * @version    1.0
 */
class TagLibBpi extends TagLib {

    //TODO:补充便签库
    protected $tags = array(
        //跨项目引入文件
        'BInclude' => array('attr' => 'file', 'close' => 0),
        //前台引入文件
        'BFInclude' => array('attr' => 'file', 'close' => 0),
        'BPIblock' => array("attr" => "block_id", "close" => 0),
        'ad' => array("attr" => "ad_id", "close" => 0),
        'BSelect' => array('attr' => 'id,name,style,change,dblclick,first,firstvalue,selected,valuefield,textfield,values,output,multiple,size', 'close' => 0),
        'BTextarea' => array('attr' => 'id,name,style,content,title,noflexible', 'close' => 0),
//        //TODO:有缺陷，拉取不准确，上下一篇
        'BPreNext' => array('attr' => 'blank,msg', 'close' => 0),
        //内容标签
        'BContent' => array('attr' => 'action,category_id,model_id,order,page,list_row,format_type,cache_time,where,return'),
        //友情链接
        'link' => array('attr' => 'term_id,order,num,image', 'close' => 1, 'level' => '3'),
    );

    /**
     * 获取内容列表标签
     * @staticvar array $_templateParseCache
     * @param type $attr
     * @param type $content
     * @return type
     */
    public function _BContent($attr, $content) {
        //示例
//    <h1>排行列表</h1>
//    <BContent action="hitList" list_row="2" order="day">
//        <volist name="data" id="vo">
//            {$vo.title}<br/>
//        </volist>
//    </BContent>
//    <h1>推荐位数据列表</h1>
//    <BContent action="position" position_id="13" flag="" list_row="2">
//        <volist name="data" id="vo">
//            {$vo.title}<br/>
//        </volist>
//    </BContent>
//    <h1>栏目列表</h1>
//    <BContent action="categoryList" category_id="0" list_row="10" where="`is_navigate`='1'">
//        <volist name="data" id="vo">
//            {$vo.category_name}<br/>
//        </volist>
//    </BContent>
//    <h1>内容列表</h1>
//    <BContent action="contentList" category_id="24" model_id="53" where="`status`='99' AND `title`!=''"  page="1" list_row="2" order="update_time DESC,id DESC" format_type="SIMPLE" cache_time="0">
//        <volist name="data" id="vo">
//            {$vo.title}<br/>
//            {$vo.description}<br/>
//        </volist>
//    </BContent>
        static $_templateParseCache = array();
        //如果已经解析过，则直接返回变量值
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        //分析content标签的标签定义
        $tag = $this->parseXmlAttr($attr, 'content');
        //默认action
        $action = $tag['action'] = trim($tag['action']);
        $categoryId = $tag['category_id'] = intval($tag['category_id']);
        $modelId = $tag['model_id'] = intval($tag['model_id']);
        $order = $tag['order'] = trim($tag['order']);
        $page = $tag['page'] = max(intval($tag['page']), 1);
        $listRow = $tag['list_row'] = max(intval($tag['list_row']), 1);
        $formatType = $tag['format_type'] = trim($tag['format_type']); //全大写，SIMPLE,SIMPLE_THUMB,NORMAL,DETAIL
        $cacheTime = $tag['cache_time'];
        $where = $tag['where'] = addSlashes(trim($tag['where']));
        $return = $tag['return'] = trim($tag['return']) ? trim($tag['return']) : 'data';
        switch ($action) {
            case 'hitList'://获取排行数据
                $cacheTime = isset($tag['cache_time']) ? $tag['cache_time'] : 3600;
                $order = $order ? $order : C('HIT_ORDER_TYPE.WEEK');
                $hitType = C('HIT_FLAG.HIT');
                $parseStr = '<?php '
                        . '$contentListData=BService(\'Content\')->getHitContentList(' . $categoryId . ',' . $modelId . ',' . $listRow . ',\'' . $hitType . '\',\'' . $order . '\',' . $cacheTime . ');'
                        . '$' . $return . '=$contentListData[\'contentList\'];'
                        . '?>';
                break;
            case 'position'://获取推荐位数据
                $positionId = $tag['position_id'] = intval($tag['position_id']);
                $flag = $tag['flag'] = trim($tag['flag']);
                $contentService = BService('Content');
                $cacheTime = isset($tag['cache_time']) ? $tag['cache_time'] : 3600;
                $formatType = $formatType ? $formatType : $contentService::FORMAT_TYPE_ENUM_SIMPLE;
                $parseStr = '<?php '
                        . '$' . $return . '=BService(\'Content\')->getContentListByPositionId(' . $positionId . ',\'' . $flag . '\',' . $listRow . ',\'' . $formatType . '\',' . $cacheTime . ');'
                        . '?>';
                break;
            case 'categoryList'://栏目列表
                $cacheTime = isset($tag['cache_time']) ? $tag['cache_time'] : 86400;
                $categoryService = BService('Category');
                $formatType = $formatType ? $formatType : $categoryService::FORMAT_TYPE_ENUM_DETAIL;
                $parseStr = '<?php '
                        . '$categoryListData=BService(\'Category\')->getCategoryListById(' . $categoryId . ',null,null,1,' . $listRow . ',\'' . $formatType . '\',\'' . $where . '\',\'' . $order . '\',' . $cacheTime . ');'
                        . '$' . $return . '=$categoryListData[\'categoryList\'];'
                        . '?>';
                break;
            case 'contentList'://内容列表
                $cacheTime = isset($tag['cache_time']) ? $tag['cache_time'] : 3600;
                $contentService = BService('Content');
                $formatType = $formatType ? $formatType : $contentService::FORMAT_TYPE_ENUM_NORMAL;
                $parseStr = '<?php '
                        . '$contentListData=BService(\'Content\')->getContentListByCategoryId(' . $categoryId . ',' . $modelId . ',' . $page . ',' . $listRow . ',\'' . $order . '\',\'' . $formatType . '\',' . $cacheTime . ',\'' . $where . '\');'
                        . '$' . $return . '=$contentListData[\'contentList\'];'
                        . '?>';
            default:
                break;
        }
        //解析模板
        $parseStr .= $this->tpl->parse($content);
        $_templateParseCache[$cacheIterateId] = $parseStr;
        return $parseStr;
    }

    /**
     * 后台模板包含标签
     * 格式
     * <BInclude file="APP/模块/模板"/>
     * @staticvar array $_admintemplateParseCache
     * @param type $attr 属性字符串
     * @param type $content 标签内容
     * @return array
     */
    public function _BInclude($attr, $content) {
        static $_admintemplateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_admintemplateParseCache[$cacheIterateId])) {
            return $_admintemplateParseCache[$cacheIterateId];
        }
        //分析Admintemplate标签的标签定义
        $tag = $this->parseXmlAttr($attr, 'BInclude');
        $file = explode('/', $tag['file']);
        $counts = count($file);
        if ($counts < 2) {
            return false;
        } else if ($counts < 3) {
            $file_path = DS . 'Admin' . DS . 'Tpl' . DS . $tag['file'];
        } else {
            $file_path = DS . $file[0] . DS . 'Tpl' . DS . $file[1] . DS . $file[2];
        }
        //模板路径
        $TemplatePath = APP_PATH . C('APP_GROUP_PATH') . $file_path . C('TMPL_TEMPLATE_SUFFIX');
        //判断模板是否存在
        if (!file_exists_case($TemplatePath)) {
            return false;
        }
        //读取内容
        $tmplContent = file_get_contents($TemplatePath);
        //解析模板内容
        $parseStr = $this->tpl->parse($tmplContent);
        $_admintemplateParseCache[$cacheIterateId] = $parseStr;
        return $_admintemplateParseCache[$cacheIterateId];
    }

    /**
     * 载入区块模版标签
     * 格式
     * <Bblocktpl block_id="{$block_id}"/>
     * @param type $attr 属性字符串
     * @param type $content 标签内容
     * @return array
     */
    public function _BPIblock($attr, $content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        $tag = $this->parseXmlAttr($attr, 'BPIblock');
        //给模版赋值
        $parseStr = '<?php $blockList = BService(\'Block\')->getBlock(' . $tag['block_id'] . '); ?>';
        //数据库读取模版内容
        $tmplContent = D('Block/Block')->where('block_id = ' . $tag['block_id'])->getField('block_tpl');
        if (!$tmplContent) {
            $tmplContent = '<?php dump($blockList); ?>';
        }
        //解析模板内容
        $parseStr .= $this->tpl->parse($tmplContent);
        $_templateParseCache[$cacheIterateId] = $parseStr;

        return $_templateParseCache[$cacheIterateId];
    }

    /**
     * 前台模板包含标签
     * 格式
     * <template file="Member/footer"/>
     * @staticvar array $_templateParseCache
     * @param type $attr 属性字符串
     * @param type $content 标签内容
     * @return array
     */
    public function _BFInclude($attr, $content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        //分析template标签的标签定义
        $tag = $this->parseXmlAttr($attr, 'BFInclude');
        $templatePath = TEMPLATE_PATH . TMPL_THEME . DS . 'Tpl' . DS . $tag['file'] . C('TMPL_TEMPLATE_SUFFIX');
        //判断模板是否存在
        if (!file_exists_case($templatePath)) {
            //启用默认模板
            $templatePath = TEMPLATE_PATH . C('FRONT_TMPL_DEFAULT_THEME') . DS . 'Tpl' . DS . $tag['file'] . C('TMPL_TEMPLATE_SUFFIX');
            if (!file_exists_case($templatePath)) {
                return;
            }
        }
        //读取内容
        $tmplContent = file_get_contents($templatePath);
        //解析模板
        $parseStr = $this->tpl->parse($tmplContent);
        $_templateParseCache[$cacheIterateId] = $parseStr;

        return $_templateParseCache[$cacheIterateId];
    }

    /**
     * select 标签库
     * @param type $attr
     * 可包含属性
     *          id          :标签ID;
     *          name        :标签name;
     *          style       :默认样式;
     *          change      :change触发事件;
     *          dblclick    :双击触发事件;
     *          first       :第一条内容;
     *          firstvalue  :第一条内容值;
     *          selected    :被选中项;
     *          options     :内容列表;
     *          valuefield  :内容列表字段值名称;
     *          textfield   :内容列表内容字段名称;
     *          values      :内容列表2(与内容列表不能共存);
     *          output      :内容列表2对应的值列表
     *          multiple    :是否多重选择;
     *          size        :显示条目;
     * @return string
     */
    public function _BSelect($attr) {
        $tag = $this->parseXmlAttr($attr, 'select');
        $id = isset($tag['id']) ? $tag['id'] : '';
        $name = isset($tag['name']) ? $tag['name'] : '';
        $style = isset($tag['style']) ? $tag['style'] : '';
        $onchange = isset($tag['change']) ? $tag['change'] : '';
        $ondblclick = isset($tag['dblclick']) ? $tag['dblclick'] : '';
        $first = isset($tag['first']) ? $tag['first'] : '';
        $firstValue = isset($tag['firstvalue']) ? $tag['firstvalue'] : '';
        $selected = isset($tag['selected']) ? $tag['selected'] : '';
        $options = isset($tag['options']) ? $tag['options'] : '';
        $valueField = isset($tag['valuefield']) ? $tag['valuefield'] : '';
        $textField = isset($tag['textfield']) ? $tag['textfield'] : '';
        $values = isset($tag['values']) ? $tag['values'] : '';
        $output = isset($tag['output']) ? $tag['output'] : '';
        $multiple = isset($tag['multiple']) ? $tag['multiple'] : '';
        $size = isset($tag['size']) ? $tag['size'] : '';

        if ($multiple !== '') {
            $parseStr = '<select id="' . $id . '" name="' . $name . '" ondblclick="' . $ondblclick . '" onchange="' . $onchange . '" multiple="multiple" class="' . $style . '" size="' . $size . '" >';
        } else {
            $parseStr = '<select id="' . $id . '" name="' . $name . '" onchange="' . $onchange . '" ondblclick="' . $ondblclick . '" class="' . $style . '" >';
        }
        if ($first !== '') {
            $parseStr .= '<option value="' . $firstValue . '" >' . $first . '</option>';
        }
        if ($options !== '') {
            $parseStr .= '<?php  foreach($' . $options . ' as $key=>$val) { ?>';

            if ($valueField !== '')
                $parseStr .= '<?php $key = $val[\'' . $valueField . '\']; ?>';

            if ($textField !== '')
                $parseStr .= '<?php $val = $val[\'' . $textField . '\']; ?>';

            if ($selected !== '') {
                $parseStr .= '<?php if($' . $selected . ' == $key || (is_array($' . $selected . ') && in_array($key,$' . $selected . '))) { ?>';
                $parseStr .= '<option selected="selected" value="<?php echo $key ?>"><?php echo $val ?></option>';
                $parseStr .= '<?php }else { ?><option value="<?php echo $key ?>"><?php echo $val ?></option>';
                $parseStr .= '<?php } ?>';
            } else {
                $parseStr .= '<option value="<?php echo $key ?>"><?php echo $val ?></option>';
            }
            $parseStr .= '<?php } ?>';
        } else if ($values !== '') {
            $parseStr .= '<?php  for($i=0;$i<count($' . $values . ');$i++) { ?>';
            if ($selected !== '') {
                $parseStr .= '<?php if(isset($' . $selected . ') && ((is_string($' . $selected . ') && $' . $selected . ' == $' . $values . '[$i]) || (is_array($' . $selected . ') && in_array($' . $values . '[$i],$' . $selected . ')))) { ?>';
                $parseStr .= '<option selected="selected" value="<?php echo $' . $values . '[$i] ?>"><?php echo $' . $output . '[$i] ?></option>';
                $parseStr .= '<?php }else { ?><option value="<?php echo $' . $values . '[$i] ?>"><?php echo $' . $output . '[$i] ?></option>';
                $parseStr .= '<?php } ?>';
            } else {
                $parseStr .= '<option value="<?php echo $' . $values . '[$i] ?>"><?php echo $' . $output . '[$i] ?></option>';
            }
            $parseStr .= '<?php } ?>';
        }
        $parseStr .= '</select>';
        return $parseStr;
    }

    /**
     * textarea 标签库
     * @param type $attr
     * 可包含属性
     *          id          :标签ID;
     *          name        :标签name;
     *          style       :默认样式(默认含有样式textarea w500 h80);
     *          content     :内容;
     *          title       :title属性值;
     *          noflexible  :是否不可伸缩(双击输入框时可扩大/伸缩);
     *          disabled    :disabled属性
     * @return string
     */
    public function _BTextarea($attr) {
        $tag = $this->parseXmlAttr($attr, 'textarea');
        $id = isset($tag['id']) ? $tag['id'] : '';
        $name = isset($tag['name']) ? $tag['name'] : '';
        $style = 'textarea w500 h80 ' . (isset($tag['style']) ? $tag['style'] : '');
        $content = isset($tag['content']) ? $tag['content'] : '';
        $title = isset($tag['title']) ? $tag['title'] : '';
        $noFlexible = isset($tag['noflexible']) ? $tag['noflexible'] : '';
        $disabled = isset($tag['disabled']) ? $tag['disabled'] : '';
        $disabledString = $disabled ? ' disabled="disabled"' : ' ';
        if (!$noFlexible) {
            $title .= '(双击输入框可扩大/缩小)';
            $style .= ' textareaFlexible';
        }

        $parseStr = '<textarea id="' . $id . '" name="' . $name . '" class="' . $style . '" title="' . $title . '"' . $disabledString . '>' . $content . '</textarea>';
        return $parseStr;
    }

    /**
     * 获取上下一篇标签
     * 使用方法：
     *      用法示例：<prenext category_id="1" model_id="1" id="1" target="1" type="pre" msg="已经没有了" />
     * 参数说明：
     *          @category_id		栏目id，可以传入数字,可为空
     *          @model_id		模型id，可以传入数字,可为空
     *          @type		pre=上一页 next=下一页
     *          @id		信息id，可以传入数字,在内容页可以不传
     *          @target		是否新窗口打开，1 是 0否
     *          @msg		当没有上一篇时的提示语
     * @param type $attr
     * @param type $content
     * @return type
     */
    public function _BPreNext($attr, $content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        $tag = $this->parseXmlAttr($attr, 'prenext');
        //当没有内容时的提示语
        $msg = !empty($tag['msg']) ? $tag['msg'] : '已经没有了';
        //是否新窗口打开
        $target = !empty($tag['blank']) ? ' target=\"_blank\" ' : '';

        if (!$tag['id'])
            $tag['id'] = '$data[id]';
        if (!$tag['category_id'])
            $tag['category_id'] = '$data[category_id]';
        if ($tag['type'] == 'pre'){
            $type = 'LT';
            $order = 'array("id" => "DESC")';
        }else if($tag['type'] == 'next'){
            $type = 'GT';
            $order = 'array("id" => "ASC")';
        }


        
        $parsestr = '<?php ';
        if ($tag['model_id']){
            $parsestr .= '$map[\'model_id\'] = "' . $tag['model_id'] . '";';
        }
        $parsestr .= '$map[\'status\'] = "99";';
        $parsestr .= '$map[\'category_id\'] = '.$tag['category_id'].';';
        $parsestr .= '$map[\'id\'] = array("' . $type . '", ' . $tag['id'] . ');';
        $parsestr .= '$prenext = D(\'content\')->where($map)->order('.$order.')->field("id,title,url")->find();';
        $parsestr .= ' echo $prenext?"<a class=\"prenext\" href=\"".$prenext["url"]."\" ' . $target . '>".$prenext["title"]."</a>":"' . str_replace('"', '\"', $msg) . '";';
        $parsestr .= ' ?> ';

        $_templateParseCache[$cacheIterateId] = $parsestr;
        return $_templateParseCache[$cacheIterateId];
    }

    /**
     * 载入区块模版标签
     * 格式
     * <ad ad_id="1"/>
     * @param type $attr 属性字符串
     * @param type $content 标签内容
     * @return array
     */
    public function _ad($attr, $content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        $tag = $this->parseXmlAttr($attr, 'ad');
        //给模版赋值
        $parseStr = '<?php $Addata = BService(\'Ad\')->getAdcontent(' . $tag['ad_id'] . '); ?>';

        $map['ad_id'] = $tag['ad_id'];
        $map['type'] = array('NEQ', '4');
        //数据库读取模版内容
        $tmplContent = D('Ad/Ad')->where($map)->getField('tpl');
        if (!$tmplContent) {
            $tmplContent = '<volist name="Addata" id="vo">{$vo.code}</volist>';
        }
        //解析模板内容
        $parseStr .= $this->tpl->parse($tmplContent);
        $_templateParseCache[$cacheIterateId] = $parseStr;

        return $_templateParseCache[$cacheIterateId];
    }
    
    /**
     * 格式
     * <link  term_id='' order='link_id DESC' num='50' image='1'>
      </link>
     * term_id:栏目ID,在列表模板和档案模板中一般不需要指定，在首页模板中允许用","分开表示多个栏目
     * @return array
     */
    public function _link($attr,$content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        //分析template标签的标签定义
        $tag = $this->parseXmlAttr($attr, 'link');
        $name = !empty($tag['name']) ? $tag['name'] : 'data';
        $item = !empty($tag['item']) ? $tag['item'] : 'vo';
        $key = !empty($tag['key']) ? $tag['key'] : 'i';
        $empty = isset($tag['empty']) ? $tag['empty'] : '';
        $mod = isset($tag['mod']) ? $tag['mod'] : '2';
        $name = $this->autoBuildVar($name);

        // 允许使用函数设定数据集 <volist name=":fun('arg')" id="vo">{$vo.name}</volist>
        $parseStr = '<?php ';
        if ($tag['term_id']){
            $parseStr .= '$map[\'term_id\'] = "' . $tag['term_id'] . '";';
        }
        if ($tag['image']=='1'){
            $parseStr .= '$map[\'image\'] = "array(\'neq\',\'\');";';
        }
        if ($tag['order']){
            $parseStr .= '$order = "' . $tag['order'] . '";';
        }else{
            $parseStr .= '$order = "link_id DESC";';
        }
        if ($tag['num']){
            $parseStr .= '$num = "' . $tag['num'] . '";';
        }else{
            $parseStr .= '$num = "10";';
        }
        $parseStr .= '$map[\'status\'] = "1";';
        $parseStr .= '$list = D(\'link\')->where($map)->order($order)->field("link_id,url,name,image,target")->limit($num)->select();';
        $parseStr .= $name . '=$list;';
        $parseStr .= 'if(is_array(' . $name . ')): $' . $key . ' = 0;';
        if (isset($tag['length']) && '' != $tag['length']) {
            $parseStr .= ' $__LIST__ = array_slice(' . $name . ',' . $tag['offset'] . ',' . $tag['length'] . ',true);';
        } elseif (isset($tag['offset']) && '' != $tag['offset']) {
            $parseStr .= ' $__LIST__ = array_slice(' . $name . ',' . $tag['offset'] . ',null,true);';
        } else {
            $parseStr .= ' $__LIST__ = ' . $name . ';';
        }
        $parseStr .= 'if( count($__LIST__)==0 ) : echo "' . $empty . '" ;';
        $parseStr .= 'else: ';
        $parseStr .= 'foreach($__LIST__ as $key=>$' . $item . '): ';
        $parseStr .= '$mod = ($' . $key . ' % ' . $mod . ' );';
        $parseStr .= '++$' . $key . ';?>';
        $parseStr .= $this->tpl->parse($content);
        $parseStr .= '<?php endforeach; endif; else: echo "' . $empty . '" ;endif; ?>';


        $_templateParseCache[$cacheIterateId] = $parseStr;
        return $_templateParseCache[$cacheIterateId];
    }

}

?>
