<?php

/**
 * 自定义模板便签库类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class TagLibMarket extends TagLib {

    //TODO:补充便签库
    protected $tags = array(
        'market' => array('attr' => 'type,categoryId,model,pageIndex,listRow', 'close' => 1 ,'level' => '3'),
    );




    /**     应用市场内容调用标签
     * 格式
     * <market  type='h' categoryId='' model='' pageIndex='' listRow=''>
	   </market>
	  *model
     *row:返回文档列表总数
     *typeid:栏目ID,在列表模板和档案模板中一般不需要指定，在首页模板中允许用","分开表示多个栏目
     *titlelen:标题长度 等同于titlelength
     *infolen:表示内容简介长度 等同于infolength
     *orderby:文档排序方式
     *keyword:含有指定关键字的文档列表，多个关键字用","分
     *id:指定文档ID
     *idlist:提取特定文档（文档ID
     *limit:（起始ID从0开始）表示限定的记录范围（如：limit='1,2' 表示从ID为1的记录开始，取2条记录
     *flag:自定义属性值：头条[h]推荐[c]图片[p]幻灯[f]滚动[s]跳转[j]图文[a]加粗[b]
     *noflag:同flag，但这里是表示不包含这些属性
     *orderway:值为 desc 或 asc ，指定排序方式是降序还是顺向排序，默认为降序
     *subday:表示在多少天以内的文档
     * @return array
     */
    public function _market($attr, $content) {
        static $_templateParseCache = array();
        $cacheIterateId = md5($attr . $content);
        if (isset($_templateParseCache[$cacheIterateId])) {
            return $_templateParseCache[$cacheIterateId];
        }
        //分析template标签的标签定义
        $tag = $this->parseXmlAttr($attr, 'market');
		$name = !empty($tag['name'])?$tag['name']:'data';
        $item = !empty($tag['item'])?$tag['item']:'vo';
        $key = !empty($tag['key'])?$tag['key']:'i';
		$empty =    isset($tag['empty'])?$tag['empty']:'';
        $mod   =    isset($tag['mod'])?$tag['mod']:'2';
		$name       =   $this->autoBuildVar($name);
                
                
		// 允许使用函数设定数据集 <volist name=":fun('arg')" id="vo">{$vo.name}</volist>
        $parseStr   =  '<?php ';
        
        
        //应用下载排行榜列表
        if($tag['type']=='downloadTopAppList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getDownloadTopApplicationList(null, C(\'APPLICATION_MODEL_NAME.APP\'), 1, 10);';
            $parseStr .= $name.'=$data[applicationList];';       
        //游戏下载排行榜列表    
        }else if($tag['type']=='downloadTopGameList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getDownloadTopApplicationList(null, C(\'APPLICATION_MODEL_NAME.GAME\'), 1, 10);';
            $parseStr .= $name.'=$data[applicationList];';   
        //推荐应用列表    
        }else if($tag['type']=='recommendedAppList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getRecommendedAppList(15);';
            $parseStr .= $name.'=$data;';   
        //每日一荐程序    
        }else if($tag['type']=='oneDayOneApplication'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getOneDayOneApplication();';
            $parseStr .= $name.'=$data;';   
        //最新更新排行榜列表    
        }else if($tag['type']=='latestApplicationList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getLatestApplicationList(null, null, 1, 10);';
            $parseStr .= $name.'=$data[applicationList];';   
        //首页幻灯片    
        }else if($tag['type']=='topSliderList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getTopSlider(5);';
            $parseStr .= $name.'=$data;';   
        //首页特别推荐    
        }else if($tag['type']=='specialRecommendedList'){
            $parseStr .= '$data = BService(\'MarketView\', \'Index\')->getSpecialRecommended(4);';
            $parseStr .= $name.'=$data;';   
        }
        
        
       
        $parseStr  .=  'if(is_array('.$name.')): $'.$key.' = 0;';
		if(isset($tag['length']) && '' !=$tag['length'] ) {
			$parseStr  .= ' $__LIST__ = array_slice('.$name.','.$tag['offset'].','.$tag['length'].',true);';
		}elseif(isset($tag['offset'])  && '' !=$tag['offset']){
            $parseStr  .= ' $__LIST__ = array_slice('.$name.','.$tag['offset'].',null,true);';
        }else{
            $parseStr .= ' $__LIST__ = '.$name.';';
        }
        $parseStr .= 'if( count($__LIST__)==0 ) : echo "'.$empty.'" ;';
        $parseStr .= 'else: ';
        $parseStr .= 'foreach($__LIST__ as $key=>$'.$item.'): ';
        $parseStr .= '$mod = ($'.$key.' % '.$mod.' );';
        $parseStr .= '++$'.$key.';?>';
        $parseStr .= $this->tpl->parse($content);
        $parseStr .= '<?php endforeach; endif; else: echo "'.$empty.'" ;endif; ?>';



        $_templateParseCache[$cacheIterateId] = $parseStr;
        return $_templateParseCache[$cacheIterateId];
    }

	


}

?>
