<?php

// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// |         lanfengye <zibin_5257@163.com>
// +----------------------------------------------------------------------
/**
 * 增加配置参数
 * @author bant
 */
class Page {

    // 分页栏每页显示的页数
    public $rollPage = 5;
    // 页数跳转时要带的参数
    public $parameter;
    // 分页URL地址
    public $url = '';
    // 默认列表每页显示行数
    public $listRows = 20;
    // 起始行数
    public $firstRow;
    // 分页总页面数
    protected $totalPages;
    // 总行数
    protected $totalRows;
    // 当前页数
    protected $nowPage;
    // 分页的栏的总页数
    protected $coolPages;
    // 分页显示定制
    protected $config = array(
        'now_page' => '',
        'url_rule' => false, //是否根据传入的url规则生成url
        'page_holder' => '{$page}',
        'header' => '条记录',
        'prev' => '上一页',
        'next' => '下一页',
        'first' => '第一页',
        'last' => '最后一页',
        'theme' => ' %totalRow% %header% %nowPage%/%totalPage% 页 %upPage% %downPage% %first%  %prePage%  %linkPage%  %nextPage% %end%'
    );
    // 默认分页变量名
    protected $varPage;

    /**
     * 构造函数
     * @param type $totalRows   总条数
     * @param type $listRows    分页大小
     * @param type $parameter   分页参数,如:'search=key&name=thinkphp'
     * @param array $url        分页URL规则数组，array('index'=>'','page'='')
     * @param type $nowPage     设置当前分页
     */
    public function __construct($totalRows, $listRows = '', $parameter = '', $url = array(), $nowPage = '') {
        $this->totalRows = $totalRows;
        $this->parameter = $parameter;
        $this->varPage = C('VAR_PAGE') ? C('VAR_PAGE') : 'p';
        if (!empty($listRows)) {
            $this->listRows = intval($listRows);
        }
        $this->totalPages = ceil($this->totalRows / $this->listRows);     //总页数
        $this->coolPages = ceil($this->totalPages / $this->rollPage);

        // 读取当前页
        $this->nowPage = intval(!is_numeric($nowPage) ? (isset($_GET[$this->varPage]) ? $_GET[$this->varPage] : 0) : $nowPage);
        if ($this->nowPage < 1) {
            $this->nowPage = 1;
        } elseif (!empty($this->totalPages) && $this->nowPage > $this->totalPages) {
            $this->nowPage = $this->totalPages;
        }
        $this->firstRow = $this->listRows * ($this->nowPage - 1);
        $this->url = $url;
    }

    /**
     * 设置配置
     * @param string||array $name        配置的key(字符串或数组)
     * @param type $value       配置的value
     * @return string           返回是否操作成功
     */
    public function config($name, $value = NULL) {
        if (is_array($name)) {
            $values = array();
            foreach ($name as $key => $value) {
                if (isset($this->config[$key])) {
                    $this->config[$key] = $value;
                } else if (isset($this->config[$value])) {
                    $values[] = $this->config[$value];
                }
            }
            return $values;
        } else if (is_string($name)/* && isset($this->config[$name]) */) {
            if (is_null($value)) {
                return $this->config[$name];
            } else {
                $this->config[$name] = $value;
                return TRUE;
            }
        } else {
            return FALSE;
        }
    }

    /**
     * 分页显示输出
     * @access public
     */
    public function show() {
        if (0 == $this->totalRows)
            return '';
        $p = $this->varPage;
        $nowCoolPage = ceil($this->nowPage / $this->rollPage);

        // 分析分页参数
        if ($this->url && is_array($this->url)) {
            
        } else {
            $parameter = array();
            if ($this->parameter && is_string($this->parameter)) {
                parse_str($this->parameter, $parameter);
            } elseif (is_array($this->parameter)) {
                $parameter = $this->parameter;
            } elseif (empty($this->parameter)) {
                unset($_GET[C('VAR_URL_PARAMS')]);
                $var = !empty($_POST) ? $_POST : $_GET;
                if (empty($var)) {
                    $parameter = array();
                } else {
                    $parameter = $var;
                }
            }
            $parameter[$p] = $this->config['page_holder'];
            $this->url = U('', $parameter);
        }
        //上下翻页字符串
        $upRow = $this->nowPage - 1;
        $downRow = $this->nowPage + 1;
        if ($upRow > 0) {
            $upPage = "<a href='" . $this->_pageUrl($upRow) . "'>" . $this->config['prev'] . "</a>";
        } else {
            $upPage = '';
        }

        if ($downRow <= $this->totalPages) {
            $downPage = "<a href='" . $this->_pageUrl($downRow) . "'>" . $this->config['next'] . "</a>";
        } else {
            $downPage = '';
        }
        // << < > >>
        if ($nowCoolPage == 1) {
            $theFirst = '';
            $prePage = '';
        } else {
            $preRow = $this->nowPage - $this->rollPage;
            $prePage = "<a href='" . $this->_pageUrl($preRow) . "' >上" . $this->rollPage . "页</a>";
            $theFirst = "<a href='" . $this->_pageUrl(1) . "' >" . $this->config['first'] . "</a>";
        }
        if ($nowCoolPage == $this->coolPages) {
            $nextPage = '';
            $theEnd = '';
        } else {
            $nextRow = $this->nowPage + $this->rollPage;
            $theEndRow = $this->totalPages;
            $nextPage = "<a href='" . $this->_pageUrl($nextRow) . "' >下" . $this->rollPage . "页</a>";
            $theEnd = "<a href='" . $this->_pageUrl($theEndRow) . "' >" . $this->config['last'] . "</a>";
        }
        // 1 2 3 4 5
        $linkPage = '';
        for ($i = 1; $i <= $this->rollPage; $i++) {
            $page = ($nowCoolPage - 1) * $this->rollPage + $i;
            if ($page != $this->nowPage) {
                if ($page <= $this->totalPages) {
                    $linkPage .= '&nbsp;<a href="' . $this->_pageUrl($page) . '">&nbsp;' . $page . '&nbsp;</a>';
                } else {
                    break;
                }
            } else {
                if ($this->totalPages != 1) {
                    $linkPage .= '&nbsp;<span class="current">' . $page . '</span>';
                }
            }
        }
        $pageStr = str_replace(array('%header%', '%nowPage%', '%totalRow%', '%totalPage%', '%upPage%', '%downPage%', '%first%', '%prePage%', '%linkPage%', '%nextPage%', '%end%'), array($this->config['header'], $this->nowPage, $this->totalRows, $this->totalPages, $upPage, $downPage, $theFirst, $prePage, $linkPage, $nextPage, $theEnd), $this->config['theme']);
        return $pageStr;
    }

    /**
     * 自定义分页显示输出
     * @return string
     */
    public function frontShow($theme = '') {
        $theme = $theme ? $theme : '%first% %upPage% %linkPage% %downPage% %end%<span><font color="red">%nowPage%</font>/%totalPage%</span>';
        $this->config('theme', $theme);
        $this->config('first', '首页');
        $this->config('last', '尾页');
        $this->rollPage = 7;
        if (0 == $this->totalRows)
            return '';
        $p = $this->varPage;  //分页变量名
        //构建URL
        $url = $_SERVER['REQUEST_URI'] . (strpos($_SERVER['REQUEST_URI'], '?') ? '' : "?") . $this->parameter;
        $parse = parse_url($url);
        if (isset($parse['query'])) {
            parse_str($parse['query'], $params);
            unset($params[$p]);
            $url = $parse['path'] . '?' . http_build_query($params);
        }
        //上下翻页字符串
        $upRow = $this->nowPage - 1; //上一页页码
        $downRow = $this->nowPage + 1; //下一页页码
        $theFirst = '';  //首页字符串
        $theEnd = '';  //末页字符串
        $upPage = '';  //上一页字符串
        $downPage = '';  //下一页字符串

        if ($upRow > 0) {
            $upPage = "<a href='" . $url . "&" . $p . "=$upRow'>" . $this->config['prev'] . "</a>";
            $theFirst = "<a href='" . $url . "&" . $p . "=1' >" . $this->config['first'] . "</a>";
        }

        if ($downRow <= $this->totalPages) {
            $downPage = "<a href='" . $url . "&" . $p . "=$downRow'>" . $this->config['next'] . "</a>";
            $theEndRow = $this->totalPages;
            $theEnd = "<a href='" . $url . "&" . $p . "=$theEndRow' >" . $this->config['last'] . "</a>";
        }

        $linkPage = ''; //分页字符串
        $prevPages = intval(($this->rollPage - 1) / 2); //前面要显示的页码数
        if ($prevPages >= $this->nowPage) {
            $prevPages = $this->nowPage - 1;
        }

        $nextPages = $this->rollPage - 1 - $prevPages; //后面要显示的页码数
        if ($this->nowPage + $nextPages > $this->totalPages) {
            $nextPages = $this->totalPages - $this->nowPage;
        }

        for ($i = $prevPages; $i > 0; $i--) {
            $page = $this->nowPage - $i;
            $linkPage .= "<a href='" . $url . "&" . $p . "=$page'>" . $page . "</a>";
        }
        $linkPage .= "<a class='current'>" . $this->nowPage . "</a>";
        for ($i = 1; $i <= $nextPages; $i++) {
            $page = $this->nowPage + $i;
            $linkPage .= "<a href='" . $url . "&" . $p . "=$page'>" . $page . "</a>";
        }

        $pageStr = str_replace(
                array('%header%', '%nowPage%', '%totalRow%', '%totalPage%', '%upPage%', '%downPage%', '%first%', '%linkPage%', '%end%'), array($this->config['header'], $this->nowPage, $this->totalRows, $this->totalPages, $upPage, $downPage, $theFirst, $linkPage, $theEnd), $this->config['theme']);
        return $pageStr;
    }

    /**
     * bootstrapV3专用分页显示输出
     * @access public
     */
    public function showByBootStrap($theme) {
        $theme = $theme ? $theme : "<li><a>%totalRow% %header% %nowPage%/%totalPage% 页</a></li>%upPage% %downPage% %first% %linkPage% %end%";
        $this->config('theme', $theme);

        if (0 == $this->totalRows)
            return '';
        $p = $this->varPage;
        $nowCoolPage = ceil($this->nowPage / $this->rollPage);

        // 分析分页参数
        if ($this->url && is_array($this->url)) {
            
        } else {
            $parameter = array();
            if ($this->parameter && is_string($this->parameter)) {
                parse_str($this->parameter, $parameter);
            } elseif (is_array($this->parameter)) {
                $parameter = $this->parameter;
            } elseif (empty($this->parameter)) {
                unset($_GET[C('VAR_URL_PARAMS')]);
                $var = !empty($_POST) ? $_POST : $_GET;
                if (empty($var)) {
                    $parameter = array();
                } else {
                    $parameter = $var;
                }
            }
            $parameter[$p] = $this->config['page_holder'];
            $this->url = U('', $parameter);
        }
        //上下翻页字符串
        $upRow = $this->nowPage - 1;
        $downRow = $this->nowPage + 1;
        if ($upRow > 0) {
            $upPage = "<li><a href='" . $this->_pageUrl($upRow) . "'>" . $this->config['prev'] . "</a></li>";
        } else {
            $upPage = '';
        }

        if ($downRow <= $this->totalPages) {
            $downPage = "<li><a href='" . $this->_pageUrl($downRow) . "'>" . $this->config['next'] . "</a></li>";
        } else {
            $downPage = '';
        }
        // << < > >>
        if ($nowCoolPage == 1) {
            $theFirst = '';
            $prePage = '';
        } else {
            $preRow = $this->nowPage - $this->rollPage;
            $prePage = "<li><a href='" . $this->_pageUrl($preRow) . "' >上" . $this->rollPage . "页</a></li>";
            $theFirst = "<li><a href='" . $this->_pageUrl(1) . "' >" . $this->config['first'] . "</a></li>";
        }
        if ($nowCoolPage == $this->coolPages) {
            $nextPage = '';
            $theEnd = '';
        } else {
            $nextRow = $this->nowPage + $this->rollPage;
            $theEndRow = $this->totalPages;
            $nextPage = "<li><a href='" . $this->_pageUrl($nextRow) . "' >下" . $this->rollPage . "页</a></li>";
            $theEnd = "<li><a href='" . $this->_pageUrl($theEndRow) . "' >" . $this->config['last'] . "</a></li>";
        }

        // 1 2 3 4 5
        $linkPage = '';
        for ($i = 1; $i <= $this->rollPage; $i++) {
            $page = ($nowCoolPage - 1) * $this->rollPage + $i;
            if ($page != $this->nowPage) {
                if ($page <= $this->totalPages) {
                    $linkPage .= '<li><a href="' . $this->_pageUrl($page) . '">' . $page . '</a></li>';
                } else {
                    break;
                }
            } else {
                if ($this->totalPages != 1) {
                    $linkPage .= "<li class='active'><a href='#'>" . $page . "</a></li>";
                    ;
                }
            }
        }
        $pageStr = str_replace(array('%header%', '%nowPage%', '%totalRow%', '%totalPage%', '%upPage%', '%downPage%', '%first%', '%prePage%', '%linkPage%', '%nextPage%', '%end%'), array($this->config['header'], $this->nowPage, $this->totalRows, $this->totalPages, $upPage, $downPage, $theFirst, $prePage, $linkPage, $nextPage, $theEnd), $this->config['theme']);
        return $pageStr;
    }

    /**
     * 获得分页信息
     * @return type
     */
    public function getPageInfo() {
        return array(
            'totalPages' => $this->totalPages, //总页数
            'listRows' => $this->listRows,
            'totalRows' => $this->totalRows, //总行数
            'nowPage' => $this->nowPage, //当前页
        );
    }

    /**
     * 分页url替换生成
     * @param type $url         包含替换关键词的URL
     * @param type $page        当前页
     * @return type             返回正常的URL连接
     */
    private function _pageUrl($page, $url = '') {
        $page = intval($page);
        empty($url) && $url = $this->url;
        $pageHolder = $this->config['page_holder'];

        if (is_array($url)) {
            if (1 === $page) {
                return $url['index'];
            } else {
                $url = $url['page'];
            }
        }
        return str_replace($pageHolder, $page, $url);
    }

}
