<?php

/**
 * 管理员Action
 * @author bant 
 */
class AdminAction extends AdminBaseAction {

    protected $adminModel;
    protected $config;
    protected $user;
    protected $isSysAdmin;

    function _initialize() {
        parent::_initialize();
        $this->adminModel = D('Admin');
        $this->config = BaseAction::getVar('config');
        $this->user = BaseAction::getVar('user');
        $this->isSysAdmin = session(C('ADMIN_AUTH_KEY')) ? TRUE : FALSE;
        $roleList = M('Role')->select();
        $this->assign('roleList', $roleList);
    }

    /**
     * 管理员列表 
     */
    public function index() {
        $roleId = intval($this->_get('role_id'));
        $adminView = D('AdminView');

        $map = array();
        if (!empty($roleId)) {
            $map['role_id'] = $roleId;
        }

        $count = $adminView->where($map)->count();
        $page = page($count);
        $adminList = $adminView->limit($page->firstRow . ',' . $page->listRows)->order('user_id ASC')->where($map)->select();

        $this->assign('list', $adminList);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 添加管理员 
     */
    public function add() {
        if (!$this->isSysAdmin) {
            $this->error('权限不足');
        }
        if (IS_POST) {
            $roleId = intval($this->_post('role_id'));
            $data = $this->adminModel->create();
            $_REQUEST['password'] = $_REQUEST['passwordconfirm'] = '******';
            if ($data) {
                $data['encrypt'] = random(6);
                $data['password'] = $this->adminModel->passwordEncrypt($data['password'], $data['encrypt']);
                $id = $this->adminModel->add($data);
                if ($id) {
                    $this->addRole($id, $roleId);
                    $this->bpiAjaxReturn(true, '添加管理员成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U("Admin/Admin/index") . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加管理员失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->adminModel->getError());
            }
        } else {
            $roleList = M('Role')->where('`name` != "超级管理员"')->select();
            $this->assign('roleList', $roleList);
            $this->display('edit');
        }
    }

    /**
     * 编辑管理员
     */
    public function edit() {
        if (!$this->isSysAdmin) {
            $this->error('权限不足');
        }
        if (IS_POST) {
            $roleId = intval($this->_post('role_id'));
            $userId = intval($this->_post('user_id'));
            if ($userId == BaseAction::getVar('super_role_id')) {
                $this->bpiAjaxReturn(false, '不能修改超级管理员', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
            $data = $this->adminModel->create();
            $_REQUEST['password'] = $_REQUEST['passwordconfirm'] = '******';
            if ($data) {
                $password = $data['password'];
                if (!empty($password)) {
                    $data['encrypt'] = random(6);
                    $data['password'] = $this->adminModel->passwordEncrypt($password, $data['encrypt']);
                } else {
                    unset($data['password'], $data['encrypt']);
                }
                if ($this->adminModel->save($data) !== FALSE) {
                    $this->editRole($userId, $roleId);
                    $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '更新失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->adminModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $userId = intval($this->_get('user_id'));
            if ($userId < 1) {
                $this->error('参数无效');
            }
            if ($userId == BaseAction::getVar('super_role_id')) {
                $this->error('不能修改超级管理员');
            }
            $admin = BService('Admin')->getAdminById($userId);
            if (!$admin) {
                $this->error('无效账户');
            }
            if ($userId != $this->user['user_id'] && !$this->isSysAdmin) {
                $this->error('无修改权限');
            }
            $roleList = M('Role')->where('`name` != "超级管理员"')->select();
            $this->assign('roleList', $roleList);
            $this->assign('admin', $admin);
            $this->display();
        }
    }

    /**
     * 删除管理员
     */
    public function delete() {
        $userId = intval($this->_get('user_id'));
        if (empty($userId)) {
            $this->bpiAjaxReturn(false, '没有指定删除对象', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        $admin = BService('Admin')->getAdminById($userId);
        if ($admin['user_id'] === BaseAction::getVar('super_role_id')) {
            $this->bpiAjaxReturn(false, '超级管理员不能被删除', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if ($userId === BaseAction::getVar('user_id')) {
            $this->bpiAjaxReturn(false, '不能删除自己', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if (!$this->adminModel->delete($userId)) {
            $this->bpiAjaxReturn(false, '删除管理员失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->deleteRole($userId);
            $this->bpiAjaxReturn(true, '删除管理员成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 增加记录到Role_user表 
     * @param type $userId
     * @param type $roleId 
     */
    protected function addRole($userId, $roleId) {
        M(C('RBAC_USER_TABLE'))->add(array('role_id' => $roleId, 'user_id' => $userId));
    }

    /**
     * 删除记录
     * @param type $userId 
     */
    protected function deleteRole($userId) {
        M(C('RBAC_USER_TABLE'))->where(array('user_id' => $userId))->delete();
    }

    /**
     * 修改角色表
     * @param type $userId
     * @param type $roleId 
     */
    protected function editRole($userId, $roleId) {
        if ($roleId > 0) {
            M(C('RBAC_USER_TABLE'))->where(array('user_id' => $userId))->save(
                    array('role_id' => $roleId)
            );
        }
    }

}

?>
