<?php

/**
 * 栏目Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class CategoryAction extends AdminBaseAction {

    protected $categoryModel;
    protected $categoryPurviewModel;
    protected $modelCache;
    protected $categoryCache;

    function _initialize() {
        parent::_initialize();
        $this->categoryModel = D('Category');
        $this->categoryPurviewModel = D('CategoryPurview');
        $this->modelCache = D('Model')->getModelByType(NULL, 1);
        $this->categoryCache = FData('Category');
    }

    /**
     * 显示栏目列表
     */
    public function index() {
        //栏目缓存数据
        $categoryCache = $this->categoryCache;
        $modelCache = $this->modelCache;
        $types = array(
            C('CATEGORY_TYPE.NORMAL') => '内部栏目',
            C('CATEGORY_TYPE.SINGLE_SITE') => '<font color="blue">单网页</font>',
            C('CATEGORY_TYPE.CHAIN') => '<font color="red">外部链接</font>',
            C('CATEGORY_TYPE.TOPIC') => '<font color="green">专题栏目</font>',
        );
        //栏目列表数据
        $categoryList = array();
        if (!empty($categoryCache)) {
            foreach ($categoryCache as &$value) {
                $categoryId = $value['category_id'];
                // 类型转中文
                $value['typeName'] = $types[$value['type']];
                // 操作字符串
                switch (intval($value['type'])) {
                    case C('CATEGORY_TYPE.CHAIN'):
                        $editActionName = 'chainEdit';
                        $operateStr = ''/* '<span href="javascript:;" class="forbidden" title="外链栏目不允许添加子栏目">添加子栏目</span> | ' */;
                        $value['model_name'] = '';
                        break;
                    case C('CATEGORY_TYPE.NORMAL'):
                        $editActionName = 'edit';
                        $operateStr = '<a href="' . U('add', array('pid' => $categoryId)) . '">添加子栏目</a> | ';
                        $value['model_name'] = isset($this->modelCache[$value['model_id']]['name']) ? $this->modelCache[$value['model_id']]['name'] : '';
                        break;
                    case C('CATEGORY_TYPE.SINGLE_SITE'):
                        $editActionName = 'editSingle';
                        $operateStr = ''/* '<a href="' . U('addSingle', array('pid' => $categoryId)) . '">添加子栏目</a> | ' */;
                        $value['model_name'] = isset($this->modelCache[$value['model_id']]['name']) ? $this->modelCache[$value['model_id']]['name'] : '';
                        break;
                    case C('CATEGORY_TYPE.TOPIC'):
                        $editActionName = 'editTopic';
                        $operateStr = '<a href="' . U('addTopic', array('pid' => $categoryId)) . '">添加子栏目</a> | ';
                        $value['model_name'] = isset($this->modelCache[$value['model_id']]['name']) ? $this->modelCache[$value['model_id']]['name'] : '';
                        break;
                    default:
                        break;
                }
                $operateStr .= '<a href="' . U('Category/' . $editActionName, array('categoryId' => $categoryId)) . '">修改</a> | ';
                $operateStr .= '<a href="' . U('Category/delete', array('categoryId' => $categoryId)) . '" class="red ajax_submit ajax_confirm">删除</a>';
                $value['operateStr'] = $operateStr;

                $value['icon'] = ' <img src="' . SITE_STATIC_URL . 'Admin/Image/status-' . ($value['is_menu'] ? 1 : 0) . '.gif" />';

                //所属模型
                $value['model_name'] = '';
                foreach ($value['model'] as $modelId => $model) {
                    if (isset($modelCache[$modelId])) {
                        if (empty($value['model_name'])) {
                            $value['model_name'] .= $modelCache[$modelId]['name'];
                        } else {
                            $value['model_name'] .= '、' . $modelCache[$modelId]['name'];
                        }
                    }
                }
                //栏目url
                $value['url'] = BService('Url')->getCategoryUrl($categoryId);
                $categoryList[$categoryId] = $value;
            }
        }

        $str = "<tr>
                    <td><span class='list-avatar can-edit logClass' name='contact_list_add_avatar'></span></td>
                    <td align='center'><input name='sort[\$category_id]' type='text' size='3' value='\$sort'></td>
                    <td align='center'>\$category_id</td>
                    <td align='left'>\$spacer\$category_name</td>
                    <td align='center'>\$model_name</td>
                    <td><a href='\$url' target='_blank'>访问</td>
                    <td>\$typeName</td>
                    <td>\$icon</td>
                    <td align='center'><div class='w150' align='right'>\$operateStr</div></td>
                </tr>";

        $categoryTree = getTree($categoryList, $str);
        $this->assign('list', $categoryTree);
        $this->display();
        unset($categoryCache, $categoryTree);
    }

    /**
     * 增加栏目
     */
    public function add() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.NORMAL'), FALSE, intval($this->_get('pid')));
        }
    }

    /**
     * 编辑栏目
     */
    public function edit() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.NORMAL'), TRUE, intval($this->_get('categoryId')));
        }
    }

    /**
     * 删除栏目
     */
    public function delete() {
        $categoryId = intval($this->_get('categoryId'));
        //获取栏目数据
        $category = $this->categoryCache[$categoryId];
        if (empty($category)) {
            $this->bpiAjaxReturn(false, '该栏目不存在', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if (C('CATEGORY_TYPE.NORMAL') === intval($category['type'])) {
            //查询是否栏目下有内容
            //查询是否有子栏目
            if (empty($category['child_id_array'])) {//没有子栏目
                $where['category_id'] = $categoryId;
            } else {
                $where['category_id'] = array('IN', $category['child_id_array']);
            }
            if (M('Content')->where($where)->count()) {
                $this->bpiAjaxReturn(false, '该栏目下存在信息，无法删除', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
            }
        }
        //删除后置操作
        $this->_afterHandleCategoryAction('delete', $categoryId);
        $this->deleteCategoryChildren($categoryId);
        $this->bpiAjaxReturn(true, '栏目删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 添加外部链接栏目 
     */
    public function chainAdd() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.CHAIN'), FALSE, intval($this->_get('pid')));
        }
    }

    /**
     * 修改外部链接栏目
     */
    public function chainEdit() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.CHAIN'), TRUE, intval($this->_get('categoryId')));
        }
    }

    /**
     * 添加单页面
     */
    public function addSingle() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.SINGLE_SITE'), FALSE, intval($this->_get('pid')));
        }
    }

    /**
     * 编辑单页面
     */
    public function editSingle() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.SINGLE_SITE'), TRUE, intval($this->_get('categoryId')));
        }
    }

    /**
     * 添加专题栏目
     */
    public function addTopic() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.TOPIC'), FALSE, intval($this->_get('pid')));
        }
    }

    /**
     * 编辑专题栏目
     */
    public function editTopic() {
        if (IS_POST) {
            $this->_postCategoryForm();
        } else {
            $this->_showCategoryForm(C('CATEGORY_TYPE.TOPIC'), TRUE, intval($this->_get('categoryId')));
        }
    }

    /**
     * 栏目排序
     */
    public function sort() {
        parent::saveSort($this->categoryModel, $this->_post('sort'), 'sort', true);
    }

    /**
     * 递归删除子栏目 
     */
    protected function deleteCategoryChildren($categoryId) {
        $categoryId = intval($categoryId);
        if (empty($categoryId)) {
            return false;
        }

        $category = $this->categoryModel->where(array('pid' => $categoryId))->select();
        if (!empty($category)) {
            foreach ($category as &$value) {
                $this->deleteCategoryChildren($value['category_id']);
                //删除后置操作
                $this->_afterHandleCategoryAction('delete', $value['category_id']);
                //删除对应数据表种的信息
                $this->deleteCategoryChildrenData($categoryId, $value['model_id']);
            }
        }
    }

    /**
     * 删除子栏目数据 
     */
    protected function deleteCategoryChildrenData($categoryId, $modelId) {
        if (isset($this->modelCache[$modelId])) {
            $tableName = $this->modelCache[$modelId]['tablename'];
            M(ucwords($tableName))->where(array('category_id' => $categoryId))->delete();
            M(ucwords($tableName) . C('SIDE_TABLE_SUFFIX'))->where(array('category_id' => $categoryId))->delete();
        }
    }

    /**
     * 处理栏目之后的后置操作
     * @param string $actionType 栏目操作,0=>delete，1=>edit or add
     * @param type $categoryId 栏目id
     * @param type $isHandleAttachment 是否操作附件
     * @param type $purviewParam 传入的权限参数
     */
    private function _afterHandleCategoryAction($actionType = 'delete', $categoryId = 0, $attachmentId = 0, $purviewParam = array()) {
        if ($actionType == 'delete') { //删除操作
            //删除栏目表条目
            $this->categoryModel->where(array('category_id' => $categoryId))->delete();
            //删除栏目权限表条目
            $this->categoryPurviewModel->where(array('category_id' => $categoryId))->delete();
            //删除附件
            BService('Attachment')->apiDelete(C('ACCESS_TYPE.CATEGORY'), $categoryId, $attachmentId);
        } else { //增加or修改操作
            //更新插件状态
            if ($attachmentId) {
                BService('Attachment')->apiUpdate(C('ACCESS_TYPE.CATEGORY'), $categoryId, $attachmentId);
            }
            $purviewRole = $purviewParam['purview_role'];
            $purviewMember = $purviewParam['purview_member'];
            //更新角色栏目权限
            $this->_updatePurview($categoryId, $purviewRole, 1);
            //更新会员组权限
            $this->_updatePurview($categoryId, $purviewMember, 0);
            // TODO : 从生成静态更改为不生成静态时，应该删除已经生成的静态文件。改栏目英文名称也要重新生成
        }
    }

    /**
     * 私有方法，处理 add 和 edit Action
     * @return type
     */
    private function _postCategoryForm() {
        //处理过滤提交数据
        $post = $this->_post();
        if (isset($post['info']['category_id'])) {
            $categoryId = $post['info']['category_id'];
        }

        //处理模板
        foreach ($post['info']['model'] as $_modelId => $_value) {
            if ($_value['show']) {//如果勾选模型，则指定模板存放到setting中
                $post['setting']['content_template_model_id_' . $_modelId] = $_value['content_template'];
            }
        }

        //设置所属内容模块
        //TODO:动态合并处理
        $post['info']['module'] = 'Content';

        //栏目类型，0为正常栏目，1为单页(废除)，2为外部栏目
        $post['info']['type'] = intval($this->_post('type'));
        if (in_array($post['info']['type'], array(C('CATEGORY_TYPE.NORMAL'), C('CATEGORY_TYPE.SINGLE_SITE'), C('CATEGORY_TYPE.TOPIC')))) {
            // 静态配置处理
            $post['info']['is_set_html'] = intval($post['setting']['is_set_html']);
            $post['info']['setting'] = serialize($post['setting']);
        }

        // 判断模型
//        $modelId = intval($post['info']['model_id']);
//        if (0 === $modelId) {
//            $this->bpiAjaxReturn(false, '请选择模型');
//        } else if (!array_key_exists($modelId, $this->modelCache) && $post['info']['type'] !== C('CATEGORY_TYPE.CHAIN')) {
//            $this->bpiAjaxReturn(false, '所选模型非法');
//        }
        // 获取显示模型的列表
        $showModelList = array();
        foreach ($post['info']['model'] as $modelId => $value) {
            $value['show'] && $showModelList[$modelId] = ''; //暂只存储modelid
        }
        $post['info']['model'] = serialize($showModelList);


        // TODO: 栏目拼音
//            $categoryName = iconv('utf-8', 'gbk', $_POST['info']['category_name']);
//            $letters = gbk_to_pinyin($categoryName);
//            $post['info']['letter'] = strtolower(implode('', $letters));
        //去除child属性，防止意外发生，如需改变栏目属性，使用属性转换功能
        unset($post['info']['child']);

        //处理缩略图
        $operate = C('OPERATE_TYPE.OPERATE_UPDATE');
        if (($attachmentId = intval($post['attachment_id']))) {
            //检测附件是否存在
            if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                $post['info']['image'] = $attachmentInfo['file_path'];
            } else {
                $this->bpiAjaxReturn(false, '栏目缩略图出错', array(), $operate);
            }
        }

        $categoryModel = D('Category');
        if ($categoryModel->create($post['info'])) {
            $success = FALSE;
            switch (ACTION_NAME) {
                case 'add':
                case 'chainAdd':
                case 'addSingle':
                case 'addTopic':
                    $operate = C('OPERATE_TYPE.OPERATE_ADD');
                    $categoryId = $categoryModel->add();
                    if ($categoryId) {
                        $success = TRUE;
                    }
                    break;
                case 'edit':
                case 'chainEdit':
                case 'editTopic':
                case 'editSingle':
                    if (FALSE !== $categoryModel->save()) {
                        $success = TRUE;
                    }
                    break;
                default:
                    break;
            }

            if ($success) {
                $purviewParam = array(
                    'purview_role' => $post['purview_role'],
                    'purview_member' => $post['purview_member'],
                );
                //后置操作
                $this->_afterHandleCategoryAction('editOrAdd', $categoryId, $attachmentId, $purviewParam);
                $this->bpiAjaxReturn(true, '操作成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/Category/index') . '"'), $operate);
            } else {
                $this->bpiAjaxReturn(false, '操作失败', array(), $operate);
            }
        } else {
            $this->bpiAjaxReturn(false, $this->categoryModel->getError(), array(), $operate);
        }
    }

    /**
     * 私有方法，显示 add 和 edit 的表单
     * @param type $type   显示栏目的类型
     * @param type $isEdit 是否编辑栏目
     * @param type $id     如果是编辑栏目，为categoryId；如果是新增，为parentId
     */
    private function _showCategoryForm($type, $isEdit = FALSE, $id = 0) {
        $type = intval($type);
        $categoryList = $this->categoryCache;
        //验证传入id
        $pid = intval($id);
        if (!empty($pid)) {
            if (empty($categoryList[$pid])) {
                $this->error('栏目不存在');
            }
        }

        //根据不同情况初始化，并把栏目数据注册到模版
        $category = array();
        if ($isEdit) {
            $category = $categoryList[$pid];
            if (is_array($category)) {
                // 取得pid，并且注册栏目变量
                $pid = intval($category['pid']);
                $this->assign('setting', $category['setting']);
                $this->assign('category', $category);
            } else {
                $pid = 0;
            }
        } else {
            if (intval($categoryList[$pid]['type']) === C('CATEGORY_TYPE.CHAIN')) {
                $this->error('外链栏目不能添加子栏目');
            }
        }
        // 格式化栏目父分类字符串，并且注册到模版
        $str = "<option value='\$category_id' \$selected>\$spacer \$category_name</option>";
        $categoryTree = getTree($categoryList, $str, $pid);
        $this->assign('categoryList', $categoryTree);

        //普通栏目处理
        if (in_array($type, array(C('CATEGORY_TYPE.NORMAL'), C('CATEGORY_TYPE.SINGLE_SITE'), C('CATEGORY_TYPE.TOPIC')))) {

            // URL规则处理
            $urlRuleList = array();
            foreach (FData('UrlRule') as $_urlType => $urlRules) {
                foreach ($urlRules as $urlRule) {
                    $isSetHtml = $urlRule['is_set_html'];
                    $urlRuleList[$_urlType][$isSetHtml][$urlRule['url_rule_id']] = ($isSetHtml ? '静态：' : '动态：') . '' . $urlRule['name'] . ' ' . $urlRule['url_rule_page'];
                }
            }

            // 权限列表
            if ($isEdit) {
                $purviews = M('CategoryPurview')->where(array('category_id' => $id))->select();
            }

            // 角色权限
            $roleGroup = M('Role')->order('id ASC')->select();
            $superAdminRoleId = BaseAction::getVar('super_role_id');
            $rolePurviewActions = array(
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.INDEX') => '查看',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.ADD') => '添加',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.EDIT') => '修改',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.DELETE') => '删除',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.SORT') => '排序',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.PUSH') => '推送',
                C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.MOVE') => '移动',
            );

            foreach ($roleGroup as &$role) {
                $role['disabled'] = (intval($role['id']) === $superAdminRoleId);
                if (is_array($purviews)) {
                    foreach (array_keys($rolePurviewActions) as $action) {
                        $role['checked'][$action] = $this->checkCategoryPurview($purviews, $action, $role['id']);
                    }
                }
            }

            // 会员组权限
            $memberGroup = FData('MemberGroup');
            $memberPurviewActions = array(C('CATEGORY_MEMBER_PURVIEW_ACTION_LIST.ADD') => '投稿');

            foreach ($memberGroup as &$member) {
                if (is_array($purviews)) {
                    foreach (array_keys($memberPurviewActions) as $action) {
                        $member['checked'][$action] = $this->checkCategoryPurview($purviews, $action, $member['group_id'], 0);
                    }
                }
            }

            // 生成列表
            $generateList = array();
            $generateTypes = C('GENERATE_TYPE');
            foreach (combinations($generateTypes) as $value) {
                $index = 0;
                $name = array();
                foreach ($value as $generateType) {
                    $index |= $generateType[0];
                    array_push($name, $generateType[1]);
                }

                $generateList[$index] = empty($name) ? '不生成' : '生成' . implode('、', $name);
            }

            // 获取模版列表
            $templateList = array();
            $theme = BaseAction::getVar('config/theme');
            $currentTemplatePath = TEMPLATE_PATH . (empty($theme) ? C('FRONT_TMPL_DEFAULT_THEME') : $theme) . DS .'Tpl'.DS . C('DEFAULT_GROUP') . DS;
            foreach (glob($currentTemplatePath . '*') as $dir) {
                if (is_dir($dir)) {
                    $templateList[basename($dir)] = getFrontTemplateList($dir);
                }
            }

            // 更改模型设置
            $modelList = $this->modelCache;
            if ($isEdit) {
                foreach ($modelList as &$model) {
                    $model['setting']['is_show'] = array_key_exists($model['model_id'], $category['model']) ? 1 : 0;
                }
            }

            $this->assign('generateList', $generateList);
            $this->assign('urlRuleList', $urlRuleList);
            $this->assign('modelList', $modelList);
            $this->assign('roleGroup', $roleGroup);
            $this->assign('rolePurviewActions', $rolePurviewActions);
            $this->assign('memberGroup', $memberGroup);
            $this->assign('memberPurviewActions', $memberPurviewActions);
            $this->assign('templateList', $templateList);
            $this->assign('type', $type); //栏目类型
            $this->display('categoryForm');
        } else if (C('CATEGORY_TYPE.CHAIN') === $type) {
            // 显示外部连接
            $this->display('chainForm');
        } else {
            $this->error('内部错误');
        }
    }

    /**
     * 检查栏目权限
     * @param type $purviews
     * @param type $action
     * @param type $roleId
     * @param type $isAdmin
     * @return string
     */
    public static function checkCategoryPurview($purviews, $action, $roleId, $isAdmin = 1) {
        return D('CategoryPurview')->checkPurview($purviews, $action, $roleId, $isAdmin);
    }

    /**
     * 更新栏目权限
     * @param type $categoryId
     * @param type $purviewData
     * @param type $isAdmin
     */
    protected function _updatePurview($categoryId, $purviewData, $isAdmin = 1) {
        D('CategoryPurview')->updatePurview($categoryId, $purviewData, $isAdmin);
    }

}

?>
