<?php

/**
 * 后台配置Action
 *
 * @author tinpont
 */
class ConfigAction extends AdminBaseAction {

    protected $config;

    function _initialize() {
        parent::_initialize();
        $this->config = D('Config');
    }

    public function index() {
        $config = $this->config->select();
        $siteConfig = array();
        foreach ($config as $v) {
            $siteConfig[$v['name']] = $v['value'];
        }

        // URL 规则处理
        $urlRuleList = FData('UrlRule');
        $indexUrlRuleList = $urlRuleList[C('URL_RULE_TYPE.INDEX')];
        foreach ($indexUrlRuleList as $key => $urlRule) {
            unset($indexUrlRuleList[$key]);
            $isSetHtml = $urlRule['is_set_html'];
            $indexUrlRuleList[$isSetHtml][$urlRule['url_rule_id']] = ($isSetHtml ? '静态：' : '动态：') . $urlRule['url_rule_page'];
        }
        $urlRuleList[C('URL_RULE_TYPE.INDEX')] = $indexUrlRuleList;

        $this->assign('site', $siteConfig);
        $this->assign('urlRuleList', $urlRuleList);
        $this->assign('indexTpList', getFrontTemplateList());
        $this->display();
    }

    public function update() {
        $post = $this->_post();
        if (!$this->config->autoCheckToken($post)) {
            $this->bpiAjaxReturn(false, '令牌验证失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
        unset($post[C('TOKEN_NAME')]);
        if ($post) {
            foreach ($post as $key => $value) {
                if (!$this->config->where(array('name' => $key))->find()) {
                    $map['name'] = $key;
                    $map['value'] = trim($value);
                    $map['info'] = '';
                    $map['group_id'] = '2';
                    $map['type'] = '0';
                    $this->config->add($map);
                } else {
                    $this->config->where(array('name' => $key))->save(array('value' => trim($value)));
                }
            }
            $this->bpiAjaxReturn(true, '保存成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        } else {
            $this->bpiAjaxReturn(false, '保存失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

}

?>
