<?php

/**
 * 词语过滤Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-23
 * @updateTime 2013-4-23
 */
class FilterWordAction extends AdminBaseAction {

    protected $filterWord, $termList, $termService;

    const MODULE_VAR_NAME = 'FilterWord'; //模块安装名称

    public function _initialize() {
        parent::_initialize();
        $this->filterWord = D('FilterWord');
        $this->termService = BService('Term');
        $this->termList = $this->termService->getTermList('FilterWord');
        $this->assign('termList', $this->termList);
    }

    /**
     * 显示首页
     */
    public function index() {
        $where = array();
        $get = $this->_get();

        if ($get['search'] == 1) {
            //分类
            $termId = intval($get['term_id']);
            if ($termId) {
                $where['term_id'] = $termId;
                $this->assign('termId', $termId);
            }

            //类型
            if ($get['type'] !== '') {
                $where['type'] = intval($get['type']);
                $this->assign('type', intval($get['type']));
            }

            //关键字
            if ($get['keyword'] !== '') {
                $where['find'] = array('LIKE', '%' . $get['keyword'] . '%');
                $this->assign('keyword', $get['keyword']);
            }
        }

        $count = $this->filterWord->where($where)->count();
        $page = page($count);

        $filterWordList = $this->filterWord->where($where)->limit($page->firstRow . ',' . $page->listRows)->order('filter_id DESC')->select();
        $this->assign('filterWordList', $filterWordList);
        $this->assign('page', $page->show());

        $this->display();
    }

    /**
     * 添加敏感词
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            //获取新建分类名
            $termName = $post['term_name'];
            $termId = intval($post['term_id']);
            //如果新建分类不为空，则新建分类
            if (!empty($termName)) {
                $termId = $this->termService->addTerm($termName, 'FilterWord');
                if (!$termId) {
                    $this->bpiAjaxReturn(false, $this->termService->getError(), array(), C('OPERATE_TYPE.OPERATE_ADD'));
                }
            }

            if (!in_array(intval($post['type']), C('FILTERWORD_TYPE'))) {
                $this->bpiAjaxReturn(false, '类型选择错误');
            }

            $map = array();
            $map['term_id'] = $termId;
            $map['type'] = intval($post['type']);
            if ($map['type'] == C('FILTERWORD_TYPE.FILTERWORD_REPLACE')) {
                $map['replacement'] = $post['replacement'];
            }

            $findList = explode("\r\n", $post['find']);

            foreach ($findList as $find) {
                if ($find) {
                    $map['find'] = $find;
                    $this->filterWord->add($map);
                }
            }
            $this->bpiAjaxReturn(true, '添加敏感词成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/FilterWord/index') . '"'));
        } else {
            $this->display('edit');
        }
    }

    /**
     * 编辑敏感词
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            //获取新建分类名
            $termName = $post['term_name'];
            $termId = intval($post['term_id']);
            //如果新建分类不为空，则新建分类
            if (!empty($termName)) {
                $termId = $this->termService->addTerm($termName, 'FilterWord');
                if (!$termId) {
                    $this->bpiAjaxReturn(false, $this->termService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }

            if (!in_array(intval($post['type']), C('FILTERWORD_TYPE'))) {
                $this->bpiAjaxReturn(false, '类型选择错误', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            $map = array();
            $map['filter_id'] = intval($post['filter_id']);
            $map['term_id'] = $termId;
            $map['type'] = intval($post['type']);
            if ($map['type'] == C('FILTERWORD_TYPE.FILTERWORD_REPLACE')) {
                $map['replacement'] = $post['replacement'];
            }
            $map['find'] = $post['find'];

            if ($this->filterWord->save($map) === false) {
                $this->bpiAjaxReturn(false, '更新敏感词失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(true, '更新敏感词成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $id = $this->_get('filter_id', 'intval', 0);
            if ($id != 0 && $data = $this->filterWord->where('filter_id = ' . $id)->find()) {
                $this->assign('data', $data);
                $this->display();
            } else {
                $this->error('敏感词不存在');
            }
        }
    }

    /**
     * 删除敏感词
     */
    public function delete() {
        $request = $this->_param();
        if (!isset($request['filter_id'])) {
            $this->bpiAjaxReturn(false, '请选择需要删除的敏感词', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        $filterList = is_array($request['filter_id']) ? $request['filter_id'] : (array) $request['filter_id'];
        foreach ($filterList as $id) {
            $id = intval($id);
            $this->filterWord->where('filter_id = ' . $id)->delete();
        }

        $this->bpiAjaxReturn(true, '删除敏感词成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 显示分类列表
     */
    public function termList() {
        $this->display('Admin@Term:termList');
    }

    /**
     * 编辑分类
     */
    public function termDelete() {
        parent::deleteTerm(self::MODULE_VAR_NAME);
    }

    /**
     * 删除分类
     */
    public function termEdit() {
        parent::editTerm(self::MODULE_VAR_NAME);
    }

}

?>
