<?php

/**
 * 后台首页 
 * @author bant
 */
class IndexAction extends AdminBaseAction {

    /**
     * 显示后台首页
     */
    public function public_index() {
        //顶部菜单
        $topMenu = BService('Menu')->getTopMenu();
        $firstMenuId = 0;
        if ($topMenu) {
            $temp = reset($topMenu);
            $firstMenuId = $temp['id'];
        }
        $indexHttpReferer = session('httpReferer') ? session('httpReferer') : U('Admin/Index/public_main');
        if ($indexHttpReferer == U('Admin/Index/public_index')) {
            $indexHttpReferer = U('Admin/Index/public_main');
        }
        session('httpReferer', null);
        $this->assign('topMenu', $topMenu);
        $this->assign('firstMenuId', $firstMenuId);
        $this->assign('indexHttpReferer', $indexHttpReferer);
        $this->assign('config', BaseAction::getVar('config'));
        $this->display('index');
    }

    /**
     * 显示main界面，环境信息等
     */
    public function public_main() {
        $info = array(
            '操作系统' => PHP_OS,
            '运行环境' => $_SERVER["SERVER_SOFTWARE"],
            'PHP运行方式' => php_sapi_name(),
            'MYSQL版本' => mysql_get_server_info(),
            '上传附件大小限制' => ini_get('upload_max_filesize') . ' (PHP环境允许上传附件的大小限制)',
            '表单提交大小限制' => ini_get('post_max_size') . ' (会影响上传附件大小)',
            '执行时间限制' => ini_get('max_execution_time') . "秒 (为0表示无限制)",
            '剩余空间' => round((@disk_free_space(".") / (1024 * 1024)), 2) . 'M',
        );

        $env = array(
            'GD库' => function_exists('gd_info') ? '正常' : '<span class="red">强烈要求开启GD库</span>',
            'CURL库' => function_exists('curl_version') ? '正常' : '<span class="red">强烈要求开启CURL库</span>',
            'mbstring库' => function_exists('mb_strlen') ? '正常' : '<span class="red">强烈要求开启mbstring库</span>',
            'zip库' => class_exists('ZipArchive') ? '正常' : '<span class="red">未开启此扩展将拉取不到APK信息</span>' 
        );

        $fileList = array(RUNTIME_PATH, LOG_PATH, TEMP_PATH, DATA_PATH, CACHE_PATH, HTML_PATH, TEMPLATE_PATH, C('UPLOAD_PATH'), C('UPLOAD_FILE_PATH'), C('UPLOAD_AVATAR_PATH'));
        $file = array();
        foreach ($fileList as $v) {
            if (!is_dir($v)) {
                $attr = '<span class="red">目录不存在</span>';
            } else {
                if (is_writable($v)) {
                    $attr = '可写';
                } else {
                    $attr = '<span class="red">不可写</span>';
                }
            }
            $file[str_replace(array(SITE_PATH, '\\'), array('', '/'), $v)] = $attr;
        }

        $this->assign('serverInfo', $info);
        $this->assign('envInfo', $env);
        $this->assign('fileInfo', $file);
        $this->display('main');
    }

    /**
     * 显示左侧菜单
     * @return type 
     */
    public function public_showLeftMenu() {
        $menuId = intval($this->_get('menuId'));
        $menu = BService('Menu')->getLeftMenu($menuId);
        $this->assign('leftMenu', $menu);
        $this->display('left');
    }

    /**
     * 获取面包屑导航
     */
    public function public_siteMap() {
        $id = intval($this->_get('menuId'));
        if ($id == 0) {
            return false;
        }
        $menu = FData('Menu');
        if (!isset($menu[$id])) {
            return false;
        }
        $siteMap = '<a href="javascript:;">' . $menu[$id]['name'] . '</a>';
        while ($id = $menu[$id]['pid']) {
            $siteMap = '<a href="javascript:;">' . $menu[$id]['name'] . '</a> &gt; ' . $siteMap;
        }
        $this->ajaxReturn($siteMap);
    }

    /**
     * 根据action获取menuId和对应URL
     */
    public function public_getMenuInfo() {
        $action = $this->_get('action');
        if (!empty($action)) {
            $menu = D('Menu')->where(array('action' => $action))->find();
            if ($menu) {
                $info = array();
                $info['url'] = U($menu['app'] . '/' . $menu['module'] . '/' . $menu['action'], array('menuId' => $menu['id'], 'menuChildId' => $menu['id']));
                $info['menuId'] = $menu['id'];
                $this->ajaxReturn($info);
            }
        }
        return false;
    }

    /**
     * 更新缓存
     */
    public function public_updateCache() {
        $type = $this->_get('type');
        if (empty($type)) {
            $this->display('cache');
        } else {
            switch ($type) {
                case 'site':
                    // 删除根目录
                    deleteDir(RUNTIME_PATH, FALSE);
                    // 删除Data目录
                    deleteDir(DATA_PATH);
                    mkdir(DATA_PATH, 0777, true);
                    // 删除数据目录
                    deleteDir(TEMP_PATH);
                    mkdir(TEMP_PATH, 0777, true);
                    // 更新缓存
                    $models = array(
                        array('info' => '配置缓存更新成功', 'model' => 'Config'),
                        array('info' => '栏目缓存更新成功', 'model' => 'Category'),
                        array('info' => '模型缓存更新成功', 'model' => 'Model'),
                        array('info' => '菜单缓存更新成功', 'model' => 'Menu'),
                        array('info' => '模型字段缓存更新成功', 'model' => 'ModelField'),
                        array('info' => '模型内容处理类缓存更新成功', 'model' => 'Content', 'method' => 'updateModelContentCache'),
                        array('info' => '会员相关缓存更新成功', 'model' => 'MemberGroup'),
                        array('info' => '搜索更新成功', 'model' => 'Search/Search'),
                        array('info' => '应用更新成功', 'model' => 'Module'),
                        array('info' => '敏感词缓存生成成功', 'model' => 'FilterWord'),
                        array('info' => '推荐位缓存生成成功', 'model' => 'Position'),
                        array('info' => 'URL规则缓存生成成功', 'model' => 'UrlRule'),
                    );

                    foreach ($models as $modelInfo) {
                        $model = D($modelInfo['model']);
                        if ($model) {
                            $methodName = isset($modelInfo['method']) ? $modelInfo['method'] : 'updateCache';
                            if (method_exists($model, $methodName)) {
                                @call_user_func(array($model, $methodName), $modelInfo['param']);
                            }
                        }
                    }
                    $this->bpiAjaxReturn(true, '站点数据缓存更新成功', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                    break;
                case 'template':
                    // 删除模版缓存
                    deleteDir(CACHE_PATH);
                    mkdir(CACHE_PATH, 0777, true);
                    $this->bpiAjaxReturn(true, '模版缓存清理成功', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                    break;
                case 'logs':
                    // 删除日志
                    deleteDir(LOG_PATH);
                    mkdir(LOG_PATH, 0777, true);
                    $this->bpiAjaxReturn(true, '站点日志清理成功', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                    break;
                default:
                    $this->bpiAjaxReturn(false, '参数错误', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                    break;
            }
        }
    }

}

?>
