<?php

/**
 * 日志管理Action
 *
 * @author bant
 */
class LogAction extends AdminBaseAction {

    /**
     * 登录日志
     */
    public function index() {
        $log = D('Log');
        $count = $log->count();
        $page = page($count);
        $data = $log->order('id DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
        $this->assign('logList', $data);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 操作日志
     */
    public function operateLog() {
        $log = D('OperateLog');
        $count = $log->count();
        $page = page($count);
        $data = $log->order('id DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
        $this->assign('logList', $data);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 查看操作日志详细信息
     */
    public function check() {
        $id = intval($this->_get('id'));
        $data = D('OperateLog')->where('id = ' . $id)->find();
        if ($data) {
            $this->assign('data', $data);
            $this->display();
        } else {
            $this->error('日志记录不存在');
        }
    }

    /**
     * 删除15天之前的登录日志
     */
    public function delete() {
        $map = array();
        $map['time'] = array('elt', time() - 15 * 86400);
        D('Log')->where($map)->delete();

        $this->bpiAjaxReturn(true, '删除记录成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'), $map);
    }

    /**
     * 删除30天之前的操作日志
     */
    public function deleteOperateLog() {
        $map = array();
        $map['time'] = array('elt', time() - 30 * 86400);
        D('OperateLog')->where($map)->delete();

        $this->bpiAjaxReturn(true, '删除记录成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'), $map);
    }

}

?>
