<?php

/**
 * 菜单Action
 *
 * @author bant
 */
class MenuAction extends AdminBaseAction {

    protected $menuModel, $menuService;

    function _initialize() {
        parent::_initialize();
        $this->menuService = BService('Menu');
        $this->menuModel = D('Menu');
    }

    /**
     * 菜单列表 
     */
    public function index() {
        $list = $this->menuModel->order(array('sort' => 'DESC', 'id' => 'ASC'))->select();

        foreach ($list as $r) {
            $r['actionManage'] = '<a href="' . U('Menu/add', array('pid' => $r['id'])) . '">添加子菜单</a> | <a href="' . U("Menu/edit", array('menu_id' => $r['id'])) . '">修改</a> | <a href="' . U("Menu/delete", array("menu_id" => $r['id'])) . '" class="red ajax_submit ajax_confirm">删除</a> ';
            $r['status'] = $r['status'] ? "显示" : "<em class='red'>不显示</em>";
            $r['parentid_node'] = ($r['pid']) ? ' class="child-of-node-' . $r['pid'] . '"' : '';
            $r['style'] = ($r['pid']) ? 'style="display:none;"' : '';
            $array[] = $r;
        }
        $string = "<tr id='node-\$id' \$parentid_node \$style>
                    <td></td>
                    <td align='center'><input name='sort[\$id]' type='text' size='3' value='\$sort' origin='\$sort' class='input'></td>
                    <td align='center'>\$id</td>
                    <td align='left'>\$spacer\$name</td>
                    <td align='center'>\$status</td>
                    <td align='center'>\$actionManage</td>
                </tr>";
        $list_tree = getTree($array, $string);
        $this->assign('menuList', $list_tree);
        $this->display();
    }

    /**
     * 添加菜单 
     */
    public function add() {
        if (IS_POST) {
            $data = $this->_post();
            if ($this->menuService->addMenu($data)) {
                $this->bpiAjaxReturn(true, '新增菜单成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/Menu/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, $this->menuService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $pid = intval($this->_get('pid'));

            // 如果有父菜单，则显示相关信息
            if (!empty($pid)) {
                $pMenu = $this->menuModel->where(array('id' => $pid))->field('app,module')->find();
                !empty($pMenu) && $this->assign('menu', $pMenu);
            }

            //显示菜单列表
            $string = "<option value='\$id' \$selected>\$spacer \$name</option>";
            $list_tree = getTree(FData('Menu'), $string, $pid);
            $this->assign('menuList', $list_tree);
            $this->display('edit');
        }
    }

    /**
     * 编辑菜单 
     */
    public function edit() {
        if (IS_POST) {
            $data = $this->_post();
            if (FALSE !== $this->menuService->editMenu($data)) {
                $this->bpiAjaxReturn(true, '编辑菜单成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/Menu/index') . '"'), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, $this->menuService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            // 获取ID参数
            $menuId = $this->_get('menu_id');
            empty($menuId) && $this->error('参数 id 不能为空');

            // 查询数据库是否存在该ID
            $menu = $this->menuModel->where(array('id' => $menuId))->find();
            empty($menu) && $this->error('参数 id 没有记录');
            $menu['status'] = $menu['status'] ? '' : 'selected';
            $menu['is_role_menu'] = $menu['is_role_menu'] ? '' : 'selected';
            //显示菜单列表
            $list = setArrayIndexByKey($this->menuModel->select(), 'id');
            $string = "<option value='\$id' pid='\$pid' \$selected>\$spacer \$name</option>";
            $listTree = getTree($list, $string, $menu['pid']);

            $this->assign('menu', $menu);
            $this->assign('menuList', $listTree);
            $this->display();
        }
    }

    /**
     * 删除菜单 
     */
    public function delete() {
        if ($this->menuService->deleteMenu($this->_get('menu_id'))) {
            $this->bpiAjaxReturn(true, '菜单删除成功', array('type' => 'function', 'data' => 'hideTableTr'), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, $this->menuService->getError(), array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 菜单排序
     */
    public function sort() {
        parent::saveSort($this->menuModel, $this->_post('sort'), 'sort', true);
    }

    public function changeStatus() {
        $menuId = intval($this->_get('menu_id'));
        $status = intval($this->_get('status'));
        if ($this->menuModel->where(array('id' => $menuId))->save(array('status' => $status))) {
            $this->bpiAjaxReturn(true, '菜单显示状态修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        } else {
            $this->bpiAjaxReturn(false, '菜单显示状态修改失败', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

}

?>
