<?php

/**
 * 模块Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-11
 * @updateTime 2013-4-11
 */
class ModuleAction extends AdminBaseAction {

    protected $moduleService;

    public function _initialize() {
        parent::_initialize();
        $this->moduleService = BService('Module');
    }

    /**
     * 显示插件列表
     */
    public function index() {
        // 拉取数据库列表
        $moduleList = FData('Module');

        // 与模块目录做比较
        foreach (glob(APP_PATH . C('APP_GROUP_PATH') . DS . '*') as $path) {
            if (is_dir($path)) {
                $moduleName = basename($path);
                $moduleConfigFile = APP_PATH . C('APP_GROUP_PATH') . DS . $moduleName . DS . 'Install' . DS . 'Config.inc.php';

                $moduleList[$moduleName]['isInstall'] = isset($moduleList[$moduleName]);
                $moduleList[$moduleName]['hasConfig'] = file_exists($moduleConfigFile);
                if ($moduleList[$moduleName]['hasConfig']) {
                    $config = @include $moduleConfigFile;
                    $moduleList[$moduleName] = array_merge($moduleList[$moduleName], $config);
                }
            }
        }

        $this->assign('moduleList', $moduleList);
        $this->display();
    }

    /**
     * 模块安装
     */
    public function install() {
        //获取module值
        $module = $this->_get('module');
        if (empty($module)) {
            $this->bpiAjaxReturn(false, '参数不能为空');
        }

        if (IS_POST) {
            if ($this->moduleService->install($module)) {
                $this->bpiAjaxReturn(true, '安装成功，请及时更新缓存', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/Module/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, $this->moduleService->getError());
            }
        } else {
            // 获取模板配置信息
            $config = $this->moduleService->check($module);
            if (is_array($config)) {
                $this->assign('config', $config);
                $this->display();
            } else {
                $this->error($this->moduleService->getError());
            }
        }
    }

    /**
     * 卸载模块
     */
    public function uninstall() {
        $moduleId = $this->_get('module_id');
        if (empty($moduleId)) {
            $this->bpiAjaxReturn(false, '内部错误', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            //执行卸载
            if ($this->moduleService->uninstall($moduleId)) {
                $this->bpiAjaxReturn(true, '模块卸载成功，请及时更新缓存', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
            } else {
                $this->bpiAjaxReturn(false, $this->moduleService->getError(), array(), C('OPERATE_TYPE.OPERATE_DELETE'));
            }
        }
    }

    /**
     * 模块配置
     */
    public function config() {
        if (IS_POST) {
            $config = D('Config');
            $post = $this->_post();
            $moduleModuleListMenuId = intval($post['module_module_list_menu_id']);
            $data = array(
                'module_module_list_menu_id' => $moduleModuleListMenuId,
            );
            if ($data) {
                foreach ($data as $key => $value) {
                    $config->where(array('name' => $key))->save(array('value' => $value));
                }
                $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, '更新错误', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $data = BaseAction::getVar('config');
            $this->assign('data', $data);
            $this->display();
        }
    }

}

?>
