<?php

/**
 * 个人信息管理Action
 */
class PersonalAction extends AdminBaseAction {

    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 修改个人信息
     */
    public function editInfo() {
        if (IS_POST) {
            $request = $this->_post();
            $adminModel = D('Admin');

            $data = $adminModel->create();
            if ($data) {
                if ($request['user_id'] != BaseAction::getVar('user_id')) {
                    $this->bpiAjaxReturn(false, '操作失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
                foreach (array('user_id', 'email', 'remark') as $key) {
                    $data[$key] = $request[$key];
                }
                if (FALSE !== $adminModel->save($data)) {
                    $this->bpiAjaxReturn(true, '更新用户资料成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '更新用户资料失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $adminModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $this->assign('info', BService('Admin')->getLoginAdmin());
            $this->display();
        }
    }

    /**
     * 修改密码
     */
    public function editPassword() {
        if (IS_POST) {
            $request = $this->_post();
            $_REQUEST['oldPassword'] = $_REQUEST['password'] = $_REQUEST['passwordConfirm'] = '******';
            $userId = intval($request['user_id']);
            $oldPassword = $request['oldPassword'];
            $newPassword = $request['password'];
            if ($userId != BaseAction::getVar('user_id')) {
                $this->bpiAjaxReturn(false, '操作失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            //验证新密码
            if (empty($request['password'])) {
                $this->bpiAjaxReturn(false, '新密码不能为空', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
            if ($newPassword !== $request['passwordConfirm']) {
                $this->bpiAjaxReturn(false, '两次输入的新密码不一致', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            //验证旧密码
            $admin = BService('Admin')->checkAdminPassword($userId, $oldPassword);
            if ($admin === false) {
                $this->bpiAjaxReturn(false, '原密码错误', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            //更新密码
            if (BService('Admin')->changePassword($userId, $newPassword)) {
                $this->bpiAjaxReturn(true, '密码修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, '密码修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $this->assign('info', BService('Admin')->getLoginAdmin());
            $this->display();
        }
    }

}

?>
