<?php

/**
 * 后台公开Action 
 */
class PublicAction extends AdminBaseAction {

    /**
     * 显示后台登陆界面 
     */
    public function login() {
        if (session(C('USER_AUTH_KEY'))) {//存在登录凭证，则跳转
            $this->redirect('Admin/Index/public_index');
        } else {
            $this->display();
        }
    }

    public function index() {
        $this->redirect('Admin/Index/public_index');
    }

    /**
     * 注销登录 
     */
    public function logout() {
        BService('Admin')->logoutAdmin();
        $this->assign('jumpUrl', U('Admin/Public/login'));
        $this->success('登出成功！');
    }

    /**
     * 登录验证 
     */
    public function checkLogin() {
        $username = $this->_post('username');
        $password = $this->_post('password');
        $verify = $this->_post('verify');
        $data = array();
        $data['status'] = 0;

        if (empty($username) || empty($password)) {
            $data['info'] = '用户名或者密码不能为空';
            $this->ajaxReturn($data);
        }

        $logService = BService('Log');
        // 后台登录强制使用验证码
        if (!BService('Verify')->checkVerify($verify, C('VERIFY_TYPE.ADMIN_LOGIN'))) {
            $data['info'] = '验证码错误';
            $logService->loginLog($username, 0, $data['info']);
            $this->ajaxReturn($data);
        }
        //RBAC认证条件
        $map = array();
        $map['user_name'] = $username;
        $map['status'] = array('gt', 0);

        import('RBAC');
        $authInfo = RBAC::authenticate($map);
        if ($authInfo == false) {
            $data['info'] = '帐号不存在或已禁用！';
            $logService->loginLog($username, 0, $data['info']);
            $this->ajaxReturn($data);
        } else {
            if ((BService('Admin')->checkAdminPassword($authInfo['user_id'], $password))) {
                //TODO:保存当前用户信息到session
                //用户认证
                session(C('USER_AUTH_KEY'), $authInfo['user_id']);
                session('user_name', $authInfo['user_name']);
                //标记为后台登录
                session('admin_flag', true);
                if ($authInfo['user_name'] == BaseAction::getVar('config/sys_admin')) {
                    session(C('ADMIN_AUTH_KEY'), true);
                }

                // 缓存访问权限
                RBAC::saveAccessList();
                $logService->loginLog($username, 1, '登录成功');
                //保存用户信息
                M('Admin')->where(array('user_id' => $authInfo['user_id']))->save(array(
                    'last_login_ip' => get_client_ip(),
                    'last_login_time' => time(),
                ));
                $data['status'] = 1;
                $data['url'] = U('Admin/Index/public_index');
                $this->ajaxReturn($data);
            } else {
                $data['info'] = '密码错误！';
                $logService->loginLog($username, 0, $data['info']);
                $this->ajaxReturn($data);
            }
        }
    }

}

?>
