<?php

/**
 * RBACAction（用户权限管理）
 * @author bant 
 */
class RbacAction extends AdminBaseAction {

    protected $roleModel;
    protected $accessModel;
    protected $accessViewModel;
    protected $nodeModel;

    function _initialize() {
        parent::_initialize();
        $this->roleModel = D('Role');
    }

    /**
     * 显示列表
     */
    public function index() {
        $roleList = D('Role')->select();
        $this->assign('roleList', $roleList);
        $this->assign('superRoleId', BaseAction::getVar('super_role_id'));
        $this->display();
    }

    /**
     * 增加角色
     */
    public function roleAdd() {
        if (IS_POST) {
            $data = $this->roleModel->create();
            if ($data) {
                $id = $this->roleModel->add($data);
                if ($id) {
                    $this->bpiAjaxReturn(true, '添加角色成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Admin/Rbac/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加角色失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->roleModel->getError());
            }
        } else {
            $this->display('roleEdit');
        }
    }

    /**
     * 编辑角色
     */
    public function roleEdit() {
        $id = (int) $this->_get('id');

        if ($id == BaseAction::getVar('super_role_id')) {
            $this->error('超级管理员角色不能被修改！');
        }
        if (IS_POST) {
            $data = $this->roleModel->create();
            if ($data) {
                if ($this->roleModel->save($data)) {
                    $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->roleModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $data = $this->roleModel->where(array('id' => $id))->find();
            if (!$data) {
                $this->error('该角色不存在！');
            }
            $this->assign('data', $data);
            $this->display();
        }
    }

    /**
     * 删除角色
     */
    public function roleDelete() {
        $id = intval($this->_get('id'));
        if (empty($id)) {
            $this->bpiAjaxReturn(false, '没有指定删除对象', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if ($id == BaseAction::getVar('super_role_id')) {
            $this->bpiAjaxReturn(false, '超级管理员组不能被删除', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if (M('RoleUser')->where(array('role_id' => $id))->count() > 0) {
            $this->bpiAjaxReturn(false, '角色列表组下存在管理员', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if (!$this->roleModel->delete($id)) {
            $this->bpiAjaxReturn(false, '删除角色失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            //删除access中的授权信息
            D('Access')->where(array('role_id' => $id))->delete();
            $this->bpiAjaxReturn(true, '删除角色成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 角色授权
     */
    public function authorize() {
        $this->accessModel = D('Access');
        $this->accessViewModel = D('AccessView');
        $this->nodeModel = D('Node');
        //授权节点队列
        $authorizeNodeQueue = array();
        if (IS_POST) {
            $roleId = intval($this->_post('roleId'));
            if (!$roleId) {
                $this->bpiAjaxReturn(false, '授权角色不存在', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
            if ($roleId == BaseAction::getVar('super_role_id')) {
                $this->bpiAjaxReturn(false, '超级管理员不能编辑', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }

            $menuIdList = $this->_post('menuId');
            if (is_array($menuIdList) && count($menuIdList) > 0) {
                $menuList = M('Menu')->getField('id,app,module,action');
                //准备待授权数据
                foreach ($menuIdList as $menuId) {
                    $menuInfo = $this->getMenuInfoByMenuId($menuId, $menuList);
                    if (!$menuInfo) {
                        continue;
                    }
                    //验证格式
                    $dataNode = $this->nodeModel->create($menuInfo);
                    if (!$dataNode) {
                        $this->bpiAjaxReturn(false, $this->nodeModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                    } else {
                        //插入待授权节点队列
                        $authorizeNodeQueue[] = $dataNode;
                    }
                }
                C('TOKEN_ON', true);
                if (BService('Rbac')->authorize($roleId, $authorizeNodeQueue)) {
                    $this->bpiAjaxReturn(true, '授权成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '授权失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                //没有数据，清除授权
                BService('Rbac')->unAuthorize($roleId);
                $this->bpiAjaxReturn(true, '执行清除授权成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $roleId = intval($this->_get('id'));
            if (!$roleId) {
                $this->error('参数错误');
            }
            if ($roleId == BaseAction::getVar('super_role_id')) {
                $this->error('超级管理员不能编辑');
            }
            $result = FData('Menu');

            //获取权限表数据
            $accessList = $this->accessViewModel->field('role_id,app,module,action')->where(array('role_id' => $roleId))->select();
            foreach ($result as $index => $t) {
                $result[$index]['checked'] = $this->checkMenuRole($t, $roleId, $accessList) ? ' checked' : '';
                $result[$index]['level'] = $this->getLevel($t['id'], $result);
                $result[$index]['parentid_node'] = ($t['pid']) ? ' class="child-of-node-' . $t['pid'] . '"' : '';
                $result[$index]['style'] = ($t['pid']) ? 'style="display:none;"' : '';
            }

            $str = "<tr id='node-\$id' \$parentid_node \$style>
                        <td style='padding-left:30px;'>\$spacer
                            <label class='labelinput'><input type='checkbox' name='menuId[]' value='\$id' level='\$level' \$checked onclick='javascript:checknode(this);'> \$name</label>
                        </td>
                    </tr>";
            $categoryList = getTree($result, $str);
            $this->assign('list', $categoryList);
            $this->assign('roleId', $roleId);
            $this->display();
        }
    }

    /**
     * 检查角色对菜单是否有权限
     * @param type $menuItem
     * @param type $roleId
     * @param type $accessList
     * @return boolean
     */
    protected function checkMenuRole($menuItem, $roleId, $accessList) {
        $accessFiled = array('app', 'module', 'action');
        if ($menuItem['app'] == '') {
            return false;
        }
        foreach (array_keys($menuItem) as $key) {
            //过滤字段
            if (!in_array($key, $accessFiled)) {
                unset($menuItem[$key]);
            }
        }
        $compareMenu = array(
            'role_id' => $roleId,
            'app' => $menuItem['app'],
            'module' => $menuItem['module'],
            'action' => $menuItem['action'],
        );
        unset($menuItem);
        $result = in_array($compareMenu, $accessList);
        return $result;
    }

    /**
     * 获取菜单深度
     * @param $id
     * @param $array
     * @param $i
     */
    protected function getLevel($id, $array = array(), $i = 0) {
        foreach ($array as $value) {
            if ($value['id'] == $id) {
                if ($value['pid'] == '0')
                    return $i;
                $i++;
                return $this->getLevel($value['pid'], $array, $i);
            }
        }
    }

    /**
     * 根据id获取菜单信息
     * @param type $menuId
     * @param type $menuList
     */
    protected function getMenuInfoByMenuId($menuId, $menuList) {
        $menu = $menuList[$menuId];
        if (!$menu) {
            return false;
        }
        $return = array(
            'app' => $menu['app'],
            'module' => $menu['module'],
            'action' => $menu['action'],
        );
        return $return;
    }

}

?>