<?php

/**
 * URL规则管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-10
 * @updateTime 2013-4-10
 */
class UrlRuleAction extends AdminBaseAction {

    protected $urlRuleModel;

    public function _initialize() {
        parent::_initialize();
        $this->urlRuleModel = D('UrlRule');
    }

    /**
     * 首页显示
     */
    public function index() {
        $urlRuleList = $this->urlRuleModel->select();

        // 分类列表
        $urlRuleTypeName = array('INDEX' => '首页', 'CATEGORY' => '栏目', 'CONTENT' => '内容', 'TAG' => '标签');
        $urlRuleType = array();
        foreach (C('URL_RULE_TYPE') as $key => $value) {
            $urlRuleType[$value] = isset($urlRuleTypeName[$key]) ? $urlRuleTypeName[$key] : $key;
        }

        $this->assign('urlRuleType', $urlRuleType);
        $this->assign('urlRuleList', $urlRuleList);
        $this->display();
    }

    /**
     * 删除规则
     */
    public function delete() {
        $urlRuleId = intval($this->_get('urlRuleId'));
        $status = $this->urlRuleModel->where(array('url_rule_id' => $urlRuleId))->delete();
        if ($status) {
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 添加规则
     */
    public function add() {
        if (IS_POST) {
            $this->_postForm(C('ACTION_TYPE.ADD'));
        } else {
            $this->_showForm();
        }
    }

    /**
     * 编辑规则
     */
    public function edit() {
        if (IS_POST) {
            $this->_postForm(C('ACTION_TYPE.EDIT'));
        } else {
            $this->_showForm();
        }
    }

    /**
     * POST数据接收
     */
    private function _postForm($actionType) {
        $operateType = $actionType === C('ACTION_TYPE.ADD') ? '' : C('OPERATE_TYPE.OPERATE_UPDATE');
        if (IS_POST) {
            $post = $this->_post();
            //还原数据为未过滤时的值
            if (empty($post['url_rule_page'])) {
                $this->bpiAjaxReturn(false, 'URL分页规则必须填写', array(), $operateType);
            } else {
                $post['url_rule_page'] = bpiHtmlspecialcharsDecode($post['url_rule_page']);
            }

            if (empty($post['url_rule_index'])) {
                $post['url_rule_index'] = $post['url_rule_page'];
            } else {
                $post['url_rule_index'] = bpiHtmlspecialcharsDecode($post['url_rule_index']);
            }

            $data = $this->urlRuleModel->create($post);
            if ($data) {
                $status = FALSE;
                if ($actionType === C('ACTION_TYPE.ADD')) {
                    $status = $this->urlRuleModel->add($data);
                } else {
                    $status = FALSE !== $this->urlRuleModel->save($data);
                }
                if ($status) {
                    $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), $operateType);
                } else {
                    $this->bpiAjaxReturn(false, '更新失败', array(), $operateType);
                }
            } else {
                $this->bpiAjaxReturn(false, $this->urlRuleModel->getError(), array(), $operateType);
            }
        } else {
            $this->bpiAjaxReturn(false, '操作失败', array(), $operateType);
        }
    }

    /**
     * 显示URL表单
     */
    private function _showForm() {
        $urlRuleId = intval($this->_get('urlRuleId'));
        if ($urlRuleId) {
            $data = $this->urlRuleModel->where(array('url_rule_id' => $urlRuleId))->find();
            $data && $this->assign('urlRule', $data);
        }

        // 分类列表
        $urlRuleTypeName = array('INDEX' => '首页', 'CATEGORY' => '栏目', 'CONTENT' => '内容', 'TAG' => '标签');
        $urlRuleType = array();
        foreach (C('URL_RULE_TYPE') as $key => $value) {
            $urlRuleType[$value] = isset($urlRuleTypeName[$key]) ? $urlRuleTypeName[$key] : $key;
        }

        $this->assign('urlRuleType', $urlRuleType);
        $this->display('edit');
    }

}

?>
