<?php

/**
 * 通信协议基类
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class HttpBaseProtocol {

    /**
     * 发送头部信息
     */
    protected function sendHeader() {
        header("HTTP/1.1 200 OK");
        //header("Content-Type: application/json; charset=UTF-8");
        header("X-Powered-By: PHPCALL Server/1.0");
        header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    }

    /**
     * 发送
     * @param type $data
     */
    protected function send($data) {
        $this->sendHeader();
        echo $this->_filter($data);
        exit;
    }

    /**
     * 获取请求内容
     * @return type
     */
    protected function getRequest() {
        return $_REQUEST;
    }

    /**
     * 过滤内容
     * @param type $data
     * @return type
     */
    private function _filter($data) {
        return str_replace('null', '"0"', $data);
    }

}

?>
