<?php

import('@.ORG.Protocol.HttpBaseProtocol');

/**
 * JSON封装的http传输协议
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class JsonProtocol extends HttpBaseProtocol {

    protected $request;
    protected $requestId;

    function __construct() {
        $this->request = $this->getRequest();
        //解析数据
        $this->requestId = isset($this->request['requestId']) ? $this->request['requestId'] : '';
    }

    /**
     * 发送返回内容
     * @param type $content
     * @param type $statusCode
     * @return type
     */
    function sendSuccess($content, $statusCode, $requestId) {
        $data['code'] = intval($statusCode);

        //TODO:SESSION_id处理
        $data['content'] = $content;
        $data['status'] = 1;
        $data = array(
            'status' => 1,
            'code' => intval($statusCode),
            'content' => $content,
            'requestId' => $requestId,
        );
        parent::send(json_encode($data));
        return;
    }

    /**
     * 
     * @param type $message
     * @param type $statusCode
     * @return type
     */
    function sendError($message, $statusCode) {
        $data = array(
            'status' => 0,
            'code' => intval($statusCode),
            'content' => $message,
        );
        parent::send(json_encode($data));
        return;
    }

    /**
     * 返回请求id
     * @return type
     */
    function getRequestId() {
        return $this->requestId;
    }

}

?>
