<?php

/**
 * 程序Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class ApplicationAction extends MarketApiBaseAction {

    public function _initialize() {
        parent::_initialize();
    }

    function setControllterCodeList() {
        return array(
            'public_getApplicationCategoryList' => 1,
            'public_getApplicationListByCategoryId' => 5,
            'public_getApplicaitionInfo' => 10,
            'public_getDownloadTopApplicationList' => 15,
            'public_getRecommendedAppList' => 18,
            'public_getTopicList' => 20,
            'public_getApplicationListByPositionId' => 25,
            'public_searchApplication' => 70,
            'public_checkApplicationListUpdate' => 75,
        );
    }

    /**
     * 获取程序栏目列表
     */
    public function public_getApplicationCategoryList() {
        $get = $this->_post();
        $modelTableName = $get['model_name'];
        if (empty($modelTableName)) {
            $appCategoryList = BService('MarketView', 'Index')->getApplicationCategoryList(C('APPLICATION_MODEL_NAME.APP'));
            $gameCategoryList = BService('MarketView', 'Index')->getApplicationCategoryList(C('APPLICATION_MODEL_NAME.GAME'));
            $categoryList = array_merge((array) $appCategoryList, (array) $gameCategoryList);
        } else {
            $categoryList = BService('MarketView', 'Index')->getApplicationCategoryList($modelTableName);
        }
        if (empty($categoryList)) {
            $categoryList = array();
        } else {
            $categoryList = BService('MarketView', 'Index')->formatSimpleCategoryList($categoryList);
        }
        $returnData = array(
            'category_list' => $categoryList,
        );
        $this->success($returnData);
    }

    /**
     * 根据栏目id获取程序数据
     */
    public function public_getApplicationListByCategoryId() {
        $post = $this->_post();
        $categoryId = intval($post['category_id']);
        if (empty($categoryId)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        $modelName = $post['model_name'];
        if (empty($modelName)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }


        $pageIndex = intval($post['page_index']);
        $listRow = $post['list_row'] ? intval($post['list_row']) : 10;
        $applicationData = BService('MarketView', 'Index')->getDownloadTopApplicationList($categoryId, $modelName, $pageIndex, $listRow, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
        $applicationList = $applicationData['applicationList'];
        $page = $applicationData['page'];

        $returnData = array(
            'application_list' => $applicationList,
            'page' => $page->getPageInfo(),
        );
        $this->success($returnData);
    }

    /**
     *  获取程序信息
     */
    public function public_getApplicaitionInfo() {
        $post = $this->_post();
        $applicationId = $post['application_id'];
        if (empty($applicationId)) {
            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
        }

        $data = BService('Application', 'Market')->getApplicationById($applicationId, NULL, NULL, true, TRUE);
        if (empty($data)) {
            $this->serviceError(1, 'APP内容获取失败');
        }
        $formatData = BService('MarketView', 'Index')->formatDetailApplication($data);

        $this->success(array('application_info' => $formatData));
    }

    /**
     * 获取下载排行程序列表
     */
    public function public_getDownloadTopApplicationList() {
        $post = $this->_post();
        $modelName = $post['model_name'];

        if (empty($modelName)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        $orderType = $post['order_type'];
        $pageIndex = intval($post['page_index']);
        $listRow = intval($post['list_row']);
        $applicationData = BService('MarketView', 'Index')->getDownloadTopApplicationList(NULL, $modelName, $pageIndex, $listRow, MarketViewService::FOTMAT_TYPE_ENUM_SIMPLE, $orderType);
        $return = array(
            'application_list' => $applicationData['applicationList'],
            'page' => $applicationData['page']->getPageInfo(),
        );

        $this->success($return);
    }

    /**
     * 获取推荐程序列表
     */
    public function public_getRecommendedAppList() {
        $post = $this->_post();
        $limitCount = $post['limit_count'] ? intval($post['limit_post']) : 6;

        $applicationList = BService('MarketView', 'Index')->getRecommendedAppList($limitCount);
        $this->success(array('application_list' => $applicationList));
    }

    /**
     * 获取专题列表
     */
    public function public_getTopicList() {
        $post = $this->_post();
        $positionList = array();
        $limitCount = $post['limit_count'] ? intval($post['limit_count']) : 6;
        $result = BService('Position')->getPositionDataList(NULL, C('POSITION_FLAG.TOPIC_FOR_APP'), $limitCount, 86400);

        foreach ($result['positionList'] as $_position) {
            $positionList[] = $this->_formatPosition($_position);
        }
        $return = array('position_list' => $positionList);
        $this->success($return);
    }

    /**
     * 根据专题id获取程序列表
     */
    public function public_getApplicationListByPositionId() {
        $post = $this->_post();
        $positionId = intval($post['position_id']);
        if (empty($positionId)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        $formatData = BService('MarketView', 'Index')->getApplicationListByPositionId($positionId);
        $return = array(
            'application_list' => $formatData,
        );
        $this->success($return);
    }

    /**
     * 应用搜索
     */
    //TODO:重写此方法
    public function public_searchApplication() {
        $post = $this->_post();
        $keyword = trim($post['keyword']);

        if (empty($keyword)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        $applicationRelationModel = new AutoRelationModel('Application');
        $resultList = $applicationRelationModel->relation(TRUE)->where(array('title' => array('LIKE', '%' . $keyword . '%')))->select();
        if (empty($resultList)) {
            $resultList = array();
        } else {
            foreach ($resultList as $_application) {
                $applicationList[] = BService('MarketView', 'Index')->formatSimpleApplicaition($_application);
            }
        }
        $this->success(array('application_list' => $applicationList));
    }

    /**
     * 检查应用升级
     */
    public function public_checkApplicationListUpdate() {
        $post = $this->_post();
        $applicationInfoList = json_decode(bpiHtmlspecialcharsDecode($post['applicationInfoList']), true);
//        $applicationInfoList = array(
//            array('package_name' => 'com.sohu.inputmethod.sogou', 'version_code' => 0),
//            array('package_name' => 'com.sougou.shurufa', 'version_code' => 0),
//        );
        if (empty($applicationInfoList)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        $result = BService('Application', 'Market')->applicationsCheckUpdate($applicationInfoList);
        if (FALSE === $result) {
            $this->serviceError(1, BService('Application', 'Market')->getError());
        }

        $this->success(array('application_list' => $result));
    }

    /**
     * 格式化专题
     * @param type $_position
     * @return type
     */
    private function _formatPosition($_position) {
        return array(
            'position_id' => $_position['position_id'],
            'desccription' => $_position['description'],
            'image' => getAttachmentSiteUrl($_position['image']),
        );
    }

}

?>
