<?php

/**
 * 评论Action
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class CommentAction extends MarketApiBaseAction {

    protected $applicationCommentService;

    public function _initialize() {
        parent::_initialize();

        $this->applicationCommentService = BService('ApplicationComment', 'Market');
    }

    function setControllterCodeList() {
        return array(
            'addComment' => 1,
            'editComment' => 2,
            'deleteComment' => 3,
            'public_getCommentList' => 4,
        );
    }

    /**
     * 添加评论
     */
    function addComment() {
        $post = $this->_post();
//            $post = array(
//                'application_id' => 1,
//                'pid' => 0,
//                'content' => '测试评论',
//                'score' => 5,
//                'version' => '1.1.1'
//            );
        $appId = $post['application_id'];
        $content = trim($post['content']);
        $score = intval($post['score']);
        if (empty($appId) || empty($content) || empty($score)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->applicationCommentService->add($appId, $content, $post, BaseAction::getVar('user_id'), $post['pid'])) {
            $this->success('评论添加成功');
        } else {
            $error = $this->applicationCommentService->getError();
            $info = empty($error) ? '评论添加失败' : $error;
            $this->serviceError(1, $info);
        }
    }

    /**
     * 编辑评论
     */
    public function editComment() {
        $this->serviceError(1);
        $post = $this->_post();
//            $post = array(
//                'comment_id' => 10,
//                'content' => '修改评论2',
//                'score' => 2,
//                'version' => '2.2.2.2'
//            );
        $commentId = intval($post['comment_id']);
        $content = trim($post['content']);
        $score = intval($post['score']);
        if (empty($commentId) || empty($content) || empty($score)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->applicationCommentService->edit($commentId, $content, $post)) {
            $this->success('评论编辑成功');
        } else {
            $error = $this->applicationCommentService->getError();
            $info = empty($error) ? '评论编辑失败' : $error;
            $this->serviceError(1, $info);
        }
    }

    /**
     * 删除评论
     */
    public function deleteComment() {
        $this->serviceError(1);
        $post = $this->_post();
//            $post = array(
//                'comment_id' => 10,
//            );
        $commentId = intval($post['comment_id']);
        if (empty($commentId)) {
            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->applicationCommentService->delete($commentId, intval(BaseAction::getVar('user_id')))) {
            $this->success('评论删除成功');
        } else {
            $error = $this->applicationCommentService->getError();
            $info = empty($error) ? '评论删除失败' : $error;
            $this->serviceError(1, $info);
        }
    }

    /**
     * 获取评论列表
     */
    public function public_getCommentList() {
        $post = $this->_post();
        $applicationId = intval($post['application_id']);
        if (empty($applicationId)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        $pageIndex = $post['page_index'] ? $post['page_index'] : 1;
        $listRow = $post['list_row'] ? $post['list_row'] : 10;
        $commentData = $this->applicationCommentService->getCommentListByApplicationId($applicationId, $pageIndex, $listRow);
        $commentList = $commentData['commentList'];
        $page = $commentData['page'];

        $returnData = array(
            'comment_list' => $commentList,
            'page' => $page->getPageInfo(),
        );
        $this->success($returnData);
    }

}

?>