<?php

/**
 * 收藏Action
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class FavoriteAction extends MarketApiBaseAction {

    protected $favoriteService;
    private $userId, $moduleId;

    public function _initialize() {
        parent::_initialize();

        $this->favoriteService = BService('Favorite', 'Favorite');
        $this->moduleId = C('ACCESS_TYPE.APPLICATION');
        $this->userId = BaseAction::getVar('user_id');
    }

    function setControllterCodeList() {
        return array(
            'isFavorite' => 1,
            'getFavoriteList' => 2,
            'addFavorite' => 3,
            'updateFavorite' => 4,
            'deleteFavorite' => 5,
        );
    }

    /**
     * 是否收藏某应用
     */
    public function isFavorite() {
        $post = $this->_post();
//            $post = array(
//                'application_id' => 5,
//            );
        $appId = $post['application_id'];
        if (empty($appId)) {
            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->favoriteService->isFavorite($this->userId, $this->moduleId, $appId)) {
            $this->success('已收藏');
        } else {
            $this->serviceError(1, '未收藏');
        }
    }

    /**
     * 获取收藏列表
     */
    public function getFavoriteList() {
        $favoriteList = $this->favoriteService->getFavoriteList($this->userId, $this->moduleId);

        if (is_array($favoriteList)) {
            $this->success(array('favorite_list' => $favoriteList));
        } else {
            $error = $this->favoriteService->getError();
            $info = empty($error) ? '获取收藏列表失败' : $error;
            $this->serviceError(1, $info);
        }
    }

    /**
     * 收藏应用
     */
    public function addFavorite() {
        $post = $this->_post();
//            $post = array(
//                'application_id' => array(4, 1),
//                'application_id' => 4,
//            );
        $appId = $post['application_id'];
        if (empty($appId)) {
            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->favoriteService->addFavorite($this->userId, $this->moduleId, $appId)) {
            $this->success('收藏成功');
        } else {
            $error = $this->favoriteService->getError();
            $info = empty($error) ? '收藏失败' : $error;
            $this->serviceError(1, $info);
        }
    }

    /**
     * 更新收藏列表
     */
//    public function updateFavorite() {
//        // 此方法会覆盖收藏，addFavorite是会保留原收藏
//        $post = $this->_post();
////            $post = array(
////                'application_id' => 1,
////            );
//        $appId = $post['application_id'];
//        if (empty($appId)) {
//            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
//        }
//
//        if ($this->favoriteService->updateFavorite($this->userId, $this->moduleId, $appId)) {
//            $this->success('收藏成功');
//        } else {
//            $error = $this->favoriteService->getError();
//            $info = empty($error) ? '收藏失败' : $error;
//            $this->serviceError(1, $info);
//        }
//    }

    /**
     * 删除收藏
     */
    public function deleteFavorite() {
        $post = $this->_post();
//            $post = array(
//                'application_id' => 1,
//            );
        $appId = $post['application_id'];
        if (empty($appId)) {
            $this->systemErrorCodeFlag(SystemRetCode::RET_ARG_MISS);
        }

        if ($this->favoriteService->deleteFavorite($this->userId, $this->moduleId, $post['application_id'])) {
            $this->success('收藏删除成功');
        } else {
            $error = $this->favoriteService->getError();
            $info = empty($error) ? '收藏删除失败' : $error;
            $this->serviceError(1, $info);
        }
    }

}

?>