<?php

/**
 * 公开Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-28
 * @updateTime 2013-5-28
 */
class PublicAction extends MockApiBaseAction {

    protected $memberConfig, $memberModel, $memberService;

    public function _initialize() {
        parent::_initialize();
        $this->memberConfig = F('MemberConfig');
        $this->memberModel = D('Member');
        $this->memberService = BService('Member');
    }

    /**
     * 设置控制器代码列表
     * @return type
     */
    function setControllterCodeList() {
        return array(
            'login' => 1,
            'logout' => 2,
            'register' => 3,
            'editPassword' => 4,
            'forgetPassword' => 5,
            'activateToken' => 11,
            'deactivateToken' => 12,
            'getConstant' => 30,
            'checkVersion' => 50,
        );
    }

    /**
     * 登录检测
     */
    public function login() {
        $post = $this->_post();
        $userName = trim($post['user_name']);
        $password = $post['password'];
        if (empty($userName) || empty($password)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        $status = BService('Member')->userLogin($userName, $password);
        if ($status > 0) {
            $info = D('Member')->where(array('user_id' => $status))->find();
            //待审核
            //TODO:此处逻辑需要整理，可能不需要审核
            $memberConfig = F('MemberConfig');
            if ($memberConfig['is_register_verify'] && !$info['status']) {
                BService('Member')->userLogout();
                $this->serviceError(2, '账号未通过审核，暂无法登录');
            }
            $this->success('登录成功');
        } else {
            $error = BService('Member')->getError();
            $this->serviceError(1, empty($error) ? '用户名或者密码错误，登录失败' : $error);
        }
    }

    /**
     * 用户注销
     */
    public function logout() {
        BService('Member')->userLogout();
        $this->success();
    }

    /**
     * 用户注册
     */
    public function register() {
        $post = $this->_post();
        if (!$this->memberConfig['is_allow_register']) {
            $this->serviceError(1, '新会员注册功能暂不开放');
        }
        $userName = trim($post['user_name']);
        $password = $post['password'];
        $email = trim($post['email']);
        if (empty($userName) || empty($password) || empty($email)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }

        $postFilter = array(
            'user_name' => $userName,
            'password' => $password,
            'email' => $email,
        );
        $data = $this->memberModel->create($postFilter);
        if ($data) {
            $userId = $this->memberService->userRegister($userName, $password, $email, $data);
            if ($userId) {
                if ($this->memberConfig['is_open_email_check']) {//发送邮件验证,邮件验证组
                    $this->success('邮件已经发送到你注册邮箱，根据邮件内容完成验证操作');
                } else {//新手上路组
                    if ($this->memberConfig['is_register_verify']) {
                        $this->success('会员注册成功，请等待管理员审核通过');
                    }
                }
                $this->success('会员注册成功');
            } else {
                $this->serviceError(10, $this->memberService->getError());
            }
        } else {//初步验证失败
            $this->serviceError(5, $this->memberModel->getError());
        }
    }

    /**
     * 忘记密码
     */
    public function forgetPassword() {
        $post = $this->_post();
        $userName = trim($post['identifier']);
        if (empty($userName)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        if ($this->memberService->sendForgetEmail($post['identifier'])) {
            $this->success('重置密码的信息已经发到您的邮箱了，请注意查收');
        } else {
            $this->serviceError(1, '用户名或邮箱不存在');
        }
    }

    /**
     * 激活token
     */
    public function activateToken() {
        $post = $this->_post();
//        $post = array(
//            'token' => 'b905aa9ff20418ec192bd0444b098d6915f9cd68e190c2fee46aed30d71f4f92',
//            'version' => '1.0',
//            'name' => 'ZYN_IPHONE'
//        );
        $token = $post['token'];
        $version = $post['version'];
        $appName = $post['name'];
        if (empty($token) || empty($version) || empty($appName)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        BService('Apn', 'App')->activateToken($token, $appName, $version);
        $this->success();
    }

    /**
     * 激活token
     */
    public function deactivateToken() {
        $post = $this->_post();
//        $post = array(
//            'token' => '455891a96c807d97af6e6795dc4237431a28dbbc17939d82499609e8edb9f647',
//            'version' => '1.0',
//            'name' => 'ZYN_IP'
//        );
        $token = $post['token'];
        $version = $post['version'];
        $appName = $post['name'];
        if (empty($token) || empty($version) || empty($appName)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        BService('Apn', 'App')->deactivateToken($token, $appName, $version);
        $this->success();
    }

    /**
     * 获取常量
     */
    public function getConstant() {
        $constantList = array(
        );
        $this->success($constantList);
    }

    /**
     * 日志记录
     */
    public function log() {
        $post = $this->_post();
        $device = $post['device'];
        $content = $post['content'];
        if (empty($content)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        $dataArray = array(
            'device' => $device,
            'content' => $content,
            'time' => time(),
        );

        $apnLogModel = D('ApnLog');
        $data = $apnLogModel->create($dataArray);
        if ($data) {
            $result = $apnLogModel->add($data);
            if ($result) {
                $this->success();
            } else {
                $this->serviceError(10, $this->memberService->getError());
            }
        } else {
            $this->serviceError(5, $apnLogModel->getError());
        }
    }

    /**
     * 版本更新
     */
    public function checkVersion() {
        $post = $this->_post();

        $type = $post['type'];
        $versionCode = trim($post['version_code']);
        if (empty($type) || empty($versionCode)) {
            $this->systemError(SystemRetCode::RET_ARG_MISS);
        }
        $result = BService('AppVersion', 'AppVersion')->checkAppVersion($type, $versionCode);
        if ($result) {
            //有更新
            $return = array(
                'version_code' => $result['version_code'],
                'content' => $result['content'],
                'url' => getAttachmentSiteUrl($result['url']),
            );
            $this->success($return);
        } else {
            $this->serviceError(1, '目前已经是最新版本');
        }
    }

}

?>
