<?php

/**
 * 移动应用模块
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2012-10-29
 * @updateTime 2012-10-29
 */
class AppAction extends AdminBaseAction {

    protected $appModel;

    public function _initialize() {
        parent::_initialize();
        $this->appModel = D('App');
    }

    /**
     * 应用列表
     */
    public function index() {
        $appList = $this->appModel->select();

        $this->assign('appList', $appList);
        $this->display();
    }

    /**
     * 应用增加
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();

            if ($this->appModel->create($post)) {
                if ($this->appModel->add()) {
                    $this->bpiAjaxReturn(true, '新增应用成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('App/App/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '新增应用失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->appModel->getError());
            }
        } else {
            $this->assign('action', 'add');
            $this->display('edit');
        }
    }

    /**
     * 应用编辑
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();

            if ($this->appModel->create($post)) {
                if ($this->appModel->save()) {
                    $this->bpiAjaxReturn(true, '编辑应用成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('App/App/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '编辑应用失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->appModel->getError());
            }
        } else {
            $appId = intval($this->_get('app_id'));
            $data = $this->appModel->where(array('app_id' => $appId))->find();
            if (!$data) {
                $this->error('应用不存在');
            }
            $this->assign('data', $data);
            $this->assign('action', 'edit');
            $this->display();
        }
    }

    /**
     * 应用删除
     */
    public function delete() {
        $appId = intval($this->_get('app_id'));
        if (!$appId) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        if ($this->appModel->where(array('app_id' => $appId))->delete()) {
            $this->bpiAjaxReturn(true, '删除应用成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除应用失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 更改状态
     */
    public function changeStatus() {
        $get = $this->_get();
        $map = array(
            'app_id' => intval($get['app_id']),
            'status' => intval($get['status']) ? 1 : 0
        );
        $status = $this->appModel->save($map);
        if ($status) {
            $this->bpiAjaxReturn(true, '更改状态成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        } else {
            $this->bpiAjaxReturn(false, '更改状态失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

}

?>
