<?php

/**
 * 消息action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-19
 * @updateTime 2013-8-19
 */
class MessageAction extends AdminBaseAction {

    protected $apnMessageModel, $apnModel;

    public function _initialize() {
        parent::_initialize();
        $this->apnMessageModel = D('ApnMessage');
        $this->apnModel = D('Apn');
    }

    /**
     * 消息列表
     */
    public function index() {
        $count = $this->apnMessageModel->where(array('status' => 1))->count();
        $page = page($count);
        $messageList = $this->apnMessageModel->where(array('status' => 1))->order('apn_message_id DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
        $this->assign('list', $messageList);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 发送消息
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            $post['time'] = time();
            $data = $this->apnMessageModel->create($post);
            if ($data) {
                //执行发送列表(苹果)
//                $tokenList = BService('Apn', 'App')->getApnList(true);
                $pushService = BService('Push', 'Task');
//                $result=true;
//                if ($tokenList) {
//                    foreach ($tokenList as $_tokenInfo) {
//                        $result|= $pushService->push2Apple($_tokenInfo['token'], $data['content']);
//                    }
//                }
                if (!$pushService->push2AndroidNow($data['title'], $data['content'])) {
                    $this->bpiAjaxReturn(false, $pushService->getError());
                }
                $status = $this->apnMessageModel->add($data);
                if (!$status) {
                    $this->bpiAjaxReturn(false, '发送消息失败');
                }
                $this->bpiAjaxReturn(true, '发送消息成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('App/Message/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, $this->apnMessageModel->getError());
            }
        } else {
            $this->assign('action', 'add');
            $this->display('edit');
        }
    }

    /**
     * 查看消息
     */
    public function edit() {
        $apnMessageId = $this->_get('apn_message_id');
        $data = $this->apnMessageModel->where(array('apn_message_id' => $apnMessageId))->find();
        if (!$data) {
            $this->error('消息不存在');
        }
        $this->assign('data', $data);
        $this->assign('action', 'edit');
        $this->display();
    }

    /**
     * 删除消息
     */
    public function delete() {
        $apnMessageId = (array) $this->_param('apn_message_id');
        $map = array(
            'apn_message_id' => array('IN', $apnMessageId)
        );
        $status = $this->apnMessageModel->where($map)->delete();
        if ($status) {
            $this->bpiAjaxReturn(true, '删除消息成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除消息失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

}

?>
