<?php

/**
 * 移动设备消息模型
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-22
 * @updateTime 2013-7-22
 */
class ApnMessageModel extends Model {

    protected $_validate = array(
        array('title', 'require', '主题不能为空'),
        array('content', 'require', '内容不能为空'),
        array('status', array(0, 1), '状态异常', 1, 'in'),
        array('content', 'checkContentLength', '内容超过最大长度', MODEL::VALUE_VALIDATE, 'callback'),
    );
    // array(填充字段,填充内容,[填充条件,附加规则])
    protected $_auto = array(
    );

    /**
     * 检查内容长度
     */
    protected function checkContentLength($data) {
        return strlen($data['content']) <= 190;
    }

}

?>
