<?php

/**
 * 设备service
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-20
 * @updateTime 2013-8-20
 */
class ApnService extends BaseService {

    protected $apnModel, $appModel;

    public function __construct() {
        parent::__construct();
        $this->apnModel = D('Apn');
        $this->appModel = D('App');
    }

    /**
     * 获取apn列表
     * @param type $isActive 是否只获取活跃状态的apn
     */
    public function getApnList($isActive = false) {
        if ($isActive) {//获取过去30天内活动的apn
            $map['last_active_time'] = array('GT', time() - 2592000);
        }
        return $this->apnModel->where($map)->select();
    }

    /**
     * 激活机器token
     * @param type $token
     * @param type $name
     * @param type $version
     */
    public function activateToken($token, $name, $version) {
        $appId = $this->appModel->where(array('name' => $name, 'version' => $version))->getField('app_id');
        if (empty($appId)) {
            $this->setError('获取应用信息失败');
            return false;
        }
        $map = array(
            'token' => $token,
            'app_id' => $appId,
        );
        $apnModel = D('Apn');
        $tokenId = $apnModel->where($map)->getField('apn_id');
        if ($tokenId) {
            //更新激活时间
            $apnModel->where(array('apn_id' => $tokenId))->setField('last_active_time', time());
            return ture;
        }
        $addData = array(
            'last_active_time' => time(),
        );
        $data = $apnModel->create(array_merge($map, $addData));
        if ($data) {
            $status = $apnModel->add($data);
            if ($status) {
                return $status;
            } else {
                $this->setError('添加token失败');
                return false;
            }
        } else {
            $this->setError($apnModel->getError());
            return false;
        }
    }

    /**
     * 反激活机器token
     * @param type $token
     * @param type $name
     * @param type $version
     * @return boolean|string
     */
    public function deactivateToken($token, $name, $version) {
        $appId = $this->appModel->where(array('name' => $name, 'version' => $version))->getField('app_id');
        if (!$appId) {
            $this->setError('获取应用信息失败');
            return false;
        }
        $map = array(
            'token' => $token,
            'app_id' => $appId,
        );
        $apnModel = D('Apn');
        $tokenId = $apnModel->where($map)->getField('apn_id');
        if ($tokenId) {
            //反激活
            $apnModel->where($map)->delete();
        }
        return ture;
    }

}

?>
