<?php

/**
 * 客户端管理
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-9-27
 */
class AppVersionAction extends AdminBaseAction {

    protected $appVersionService;

    function _initialize() {
        parent::_initialize();

        $this->appVersionService = BService('AppVersion', 'AppVersion');
    }

    /**
     * 首页
     */
    public function index() {
        $this->assign('appVersionList', M('AppVersion')->order('type ASC, version_code DESC')->select());
        $this->assign('appVersionType', array_flip(C('APP_VERSION_TYPE')));
        $this->display();
    }

    /**
     * 添加客户端版本号
     */
    public function add() {
        if (IS_POST) {
            if ($this->appVersionService->addAppVersion($this->_post())) {
                $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('AppVersion/AppVersion/index') . '"'));
            } else {
                $error = $this->appVersionService->getError();
                $info = empty($error) ? '添加失败' : $error;
                $this->bpiAjaxReturn(false, $info);
            }
        } else {
            $this->assign('appVersionType', array_flip(C('APP_VERSION_TYPE')));
            $this->display('edit');
        }
    }

    /**
     * 编辑客户端版本号
     */
    public function edit() {
        if (IS_POST) {
            if ($this->appVersionService->editAppVersion($this->_post())) {
                $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $error = $this->appVersionService->getError();
                $info = empty($error) ? '修改失败' : $error;
                $this->bpiAjaxReturn(false, $info, array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $appVersionId = intval($this->_get('app_version_id'));
            $appVersion = $this->appVersionService->getAppVersion($appVersionId);
            if (!$appVersion) {
                $this->error('信息不存在');
            }
            $this->assign('data', $appVersion);
            $this->assign('appVersionType', array_flip(C('APP_VERSION_TYPE')));
            $this->display();
        }
    }

}

?>