<?php

/**
 * 客户端Service
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-11
 * @updateTime 2013-8-11
 */
class AppVersionService extends BaseService {

    private $appVersionModel;

    public function __construct() {
        parent::__construct();

        $this->appVersionModel = D('AppVersion/AppVersion');
    }

    /**
     * 添加一个版本信息
     * @param type $data
     * @return boolean
     */
    public function addAppVersion($data) {

        // 处理附件
        if (($attachmentId = intval($data['attachment_id']))) {
            //检测附件是否存在
            if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                $data['url'] = $attachmentInfo['file_path'];
            } else {
                $this->setError('附近信息读取失败');
                return FALSE;
            }
        }

        if ($this->appVersionModel->create($data)) {
            $insertId = $this->appVersionModel->add();
            if ($insertId && $attachmentId) {
                BService('Attachment')->apiUpdate(NULL, $insertId, $attachmentId);
            }
            return $insertId;
        } else {
            $this->setError($this->appVersionModel->getError());
            return FALSE;
        }
    }

    /**
     * 编辑版本信息
     * @param type $data
     * @return boolean
     */
    public function editAppVersion($data) {
        // 处理附件
        if (($attachmentId = intval($data['attachment_id']))) {
            //检测附件是否存在
            if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                $data['url'] = $attachmentInfo['file_path'];
            } else {
                $this->setError('附近信息读取失败');
                return FALSE;
            }
        }

        if ($this->appVersionModel->create($data)) {
            $status = FALSE !== $this->appVersionModel->save();
            if ($status && $attachmentId) {
                BService('Attachment')->apiUpdate(NULL, $data['app_version_id'], $attachmentId);
            }
            return $status;
        } else {
            $this->setError($this->appVersionModel->getError());
            return FALSE;
        }
    }

    /**
     * 删除版本
     * @param type $appVersionIds       可以为单个ID，可以为数组
     * @return boolean
     */
    public function deleteAppVersion($appVersionIds) {
        // 处理ID
        is_numeric($appVersionIds) && $appVersionIds = array($appVersionIds);
        if (!is_array($appVersionIds)) {
            $this->setError('关联ID列表不合法');
            return FALSE;
        }

        if (empty($appVersionIds)) {
            $this->setError('没有选择删除内容');
            return FALSE;
        }

        $this->appVersionModel->where(array('app_version_id', array('IN', $appVersionIds)))->delete();
        return TRUE;
    }

    /**
     * 获取一个客户端版本信息
     * @param type $appVersionId        客户端版本ID
     * @return type
     */
    public function getAppVersion($appVersionId) {
        $appVersionId = intval($appVersionId);
        return $this->appVersionModel->find($appVersionId);
    }

    /**
     * 获取类型下最新的版本信息
     * @param type $type        分类ID
     */
    public function getLastAppVersion($type) {
        $type = intval($type);
        return $this->appVersionModel->where(array('type' => $type, 'status' => 1))->order('version_code DESC')->find();
    }

    /**
     * 检查版本升级
     * @param type $type        分类ID
     * @param type $version     版本号字符串，1.2.3.0
     * @return boolean
     */
    public function checkAppVersion($type, $version) {
        $appVersionInfo = $this->getLastAppVersion($type);
        if ($appVersionInfo) {
            return intval($version) < intval($appVersionInfo['version_code']) ? intval($appVersionInfo['version_code']) : false;
        }
        return FALSE;
    }

}

?>