<?php

/**
 * 前后台通用的附件Action
 * @author     bant
 * @copyright  (C) 2011-2014 EXCMS
 * @license    http://www.zyxfeng.com/license/
 * @version    1.0
 * @createTime 2013-4-18
 * @updateTime 2013-4-18
 */
class AttachmentAction extends FrontBaseAction {

    // 附件目录
    protected $filePath;
    // 附件Serivce
    protected $attachmentService;

    function _initialize() {
        parent::_initialize();
        $this->filePath = C('UPLOAD_FILE_PATH');
        $this->attachmentService = BService('Attachment');

        // TODO : 进行权限判断
    }

    /**
     * swfupload上传
     */
    public function swfupload() {
        $inAdmin = defined('IN_ADMIN') && IN_ADMIN;
        if (IS_POST) {
            $data = $this->_post();
            if (!$inAdmin) {
                $data['water'] = BaseAction::getVar('config/watermark_is_open');
                $data['qrcode'] = BaseAction::getVar('config/qrcode_is_open');
            }

            $uploadList = $this->attachmentService->upload($data);
            if ($uploadList) {
                $data = array(
                    'error_code' => 0,
                    'content' => 1 === count($uploadList) ? array_pop($uploadList) : $uploadList,
                );
                $this->ajaxReturn($data);
            } else {
                $data = array(
                    'error_code' => 1,
                    'error' => $this->attachmentService->getError(),
                );
                $this->ajaxReturn($data);
            }
        } else {
            // 查询配置，包括限制格式与限制大小
            $uploadMaxSize = intval(BaseAction::getVar('config/' . ($inAdmin ? 'upload_admin_max_size' : 'upload_max_size')));

            // 提取限制格式交集
            $uploadAllowExt = BaseAction::getVar('config/' . ($inAdmin ? 'upload_admin_allow_ext' : 'upload_allow_ext'));
            $getUploadAllowExt = $this->_get('upload_allow_ext');
            if ($getUploadAllowExt) {
                $uploadAllowExt = array_intersect(explode('|', $uploadAllowExt), explode('|', $getUploadAllowExt));
            } else {
                $uploadAllowExt = explode('|', $uploadAllowExt);
            }
            // 限制显示页面
            $allowTabs = $inAdmin ? array('upload', 'remote', 'gallery', 'dispose') : array('upload', 'remote');
            $showTab = $this->_get('show_tabs');
            $showTabs = array_intersect($allowTabs, explode(',', $showTab));
            // 交集为空的时候，显示默认页面
            if (empty($showTabs)) {
                $showTabs = $allowTabs;
            }
            // 显示默认页，为空则显示第一页
            $defaultTab = $this->_get('default_tab');
            if (!in_array($defaultTab, $showTabs)) {
                // 获取数组第一个值
                $defaultTabShow = reset($showTabs);
            }

            $module = $this->_get('module');
            $categoryId = intval($this->_get('category_id'));
            $queueLimit = intval($this->_get('queue_limit'));
            $uploadLimit = intval($this->_get('upload_limit'));

            $str = $showTab . ',' . $defaultTab . ',' . $getUploadAllowExt . ',' . $queueLimit . ',' . $uploadLimit;
            if ($this->_get('auth') != uploadAuth($str)) {
                exit('参数错误');
            }

            // 添加控制水印和QRCODE的选项
            $this->assign('water', $this->_get('water'));
            $this->assign('qrcode', $this->_get('qrcode'));

            $this->assign('showTabs', $showTabs);
            $this->assign('defaultTab', $defaultTabShow ? $defaultTabShow : $defaultTab);
            $this->assign('uploadExt', $getUploadAllowExt);
            $this->assign('queueLimit', $queueLimit);
            $this->assign('uploadLimit', $uploadLimit);

            $this->assign('file_types', '*.' . implode(';*.', $uploadAllowExt) . ';');
            $this->assign('module', $module);
            $this->assign('categoryId', $categoryId);

            $this->assign('file_size_limit', $uploadMaxSize);
            $this->display('Attachment:swfupload');
        }
    }

    /**
     * 为ueditor量身订造的swfupload
     */
    public function ueditorSwfupload() {
        if (IS_POST) {
            $data = $this->_post();

            $uploadList = $this->attachmentService->upload($data);
            if ($uploadList) {
                $info = array_pop($uploadList);

                $data = array(
                    'url' => $info['url'],
                    'title' => $info['name'],
                    'original' => $info['name'],
                    'state' => 'SUCCESS',
                    'attachment_id' => $info['id'],
                );
                $this->ajaxReturn($data);
            } else {
                $data = array(
                    'error' => $this->attachmentService->getError(),
                    'state' => 'FAILED',
                );
                $this->ajaxReturn($data);
            }
        }
    }

    /**
     * ueditor用远程文件下载
     */
    public function ueditorDownload() {
        $inAdmin = defined('IN_ADMIN') && IN_ADMIN;
        $separate = 'ue_separate_ue'; //ueditor分隔符
        $data = $this->_request();
        $id = intval($data['id']);
        $isBindOne = $id ? true : false; //是否绑定数据
        if (IS_POST) {
            if (!$inAdmin) {
                $data['water'] = BaseAction::getVar('config/watermark_is_open');
                $data['qrcode'] = BaseAction::getVar('config/qrcode_is_open');
            }
            $srcUrl = $data['upfile'];
            $urlArray = explode($separate, $srcUrl);
            $downloadedFileUrlArray = array();
            foreach ($urlArray as $_url) {
                $attachment = $this->attachmentService->downloadRemoteFile($_url, $data);
                if (!$attachment) {
                    $errorMessage = $this->attachmentService->getError();
                    echo "{'tip':'远程图片抓取失败！原因：'.$errorMessage.,'srcUrl':'" . $data['upfile'] . "'}";
                }
                $downloadedFileUrlArray[] = $attachment['url'];
                $attachmentIds[] = $attachment['id'];
            }
            if ($isBindOne) {
                $this->attachmentService->apiUpdate($data['module'], $id, $attachmentIds, C('ATTACHMENT_FLAG.EDITOR_IMAGE'));
            }
            echo "{'url':'" . implode($separate, $downloadedFileUrlArray) . "','attachmentId':'" . implode($separate, $attachmentIds) . "','tip':'远程图片抓取成功！','srcUrl':'" . $srcUrl . "'}";
        }
    }

    /**
     * 远程文件下载
     */
    public function download() {
        $inAdmin = defined('IN_ADMIN') && IN_ADMIN;
        if (IS_POST) {
            $data = $this->_post();
            if (!$inAdmin) {
                $data['water'] = BaseAction::getVar('config/watermark_is_open');
                $data['qrcode'] = BaseAction::getVar('config/qrcode_is_open');
            }
            $attachment = $this->attachmentService->downloadRemoteFile($data['url'], $data);
            if ($attachment) {
                $data = array(
                    'error_code' => 0,
                    'content' => 1 === count($attachment) ? array_pop($attachment) : $attachment,
                );
            } else {
                $data = array(
                    'error_code' => 1,
                    'error' => $this->attachmentService->getError(),
                );
            }
        } else {
            $data = array(
                'error_code' => 1,
                'error' => '未获取到文件',
            );
        }
        $this->ajaxReturn($data);
    }

}

?>
